package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertClusterMember invokes the edas.InsertClusterMember API synchronously
func (client *Client) InsertClusterMember(request *InsertClusterMemberRequest) (response *InsertClusterMemberResponse, err error) {
	response = CreateInsertClusterMemberResponse()
	err = client.DoAction(request, response)
	return
}

// InsertClusterMemberWithChan invokes the edas.InsertClusterMember API asynchronously
func (client *Client) InsertClusterMemberWithChan(request *InsertClusterMemberRequest) (<-chan *InsertClusterMemberResponse, <-chan error) {
	responseChan := make(chan *InsertClusterMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertClusterMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertClusterMemberWithCallback invokes the edas.InsertClusterMember API asynchronously
func (client *Client) InsertClusterMemberWithCallback(request *InsertClusterMemberRequest, callback func(response *InsertClusterMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertClusterMemberResponse
		var err error
		defer close(result)
		response, err = client.InsertClusterMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertClusterMemberRequest is the request struct for api InsertClusterMember
type InsertClusterMemberRequest struct {
	*requests.RoaRequest
	Password    string `position:"Query" name:"password"`
	InstanceIds string `position:"Query" name:"instanceIds"`
	ClusterId   string `position:"Query" name:"clusterId"`
}

// InsertClusterMemberResponse is the response struct for api InsertClusterMember
type InsertClusterMemberResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateInsertClusterMemberRequest creates a request to invoke InsertClusterMember API
func CreateInsertClusterMemberRequest() (request *InsertClusterMemberRequest) {
	request = &InsertClusterMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "InsertClusterMember", "/pop/v5/resource/cluster_member", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInsertClusterMemberResponse creates a response to parse from InsertClusterMember response
func CreateInsertClusterMemberResponse() (response *InsertClusterMemberResponse) {
	response = &InsertClusterMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
