package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSQLReviewCheckResultStatus invokes the dms_enterprise.GetSQLReviewCheckResultStatus API synchronously
func (client *Client) GetSQLReviewCheckResultStatus(request *GetSQLReviewCheckResultStatusRequest) (response *GetSQLReviewCheckResultStatusResponse, err error) {
	response = CreateGetSQLReviewCheckResultStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetSQLReviewCheckResultStatusWithChan invokes the dms_enterprise.GetSQLReviewCheckResultStatus API asynchronously
func (client *Client) GetSQLReviewCheckResultStatusWithChan(request *GetSQLReviewCheckResultStatusRequest) (<-chan *GetSQLReviewCheckResultStatusResponse, <-chan error) {
	responseChan := make(chan *GetSQLReviewCheckResultStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSQLReviewCheckResultStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSQLReviewCheckResultStatusWithCallback invokes the dms_enterprise.GetSQLReviewCheckResultStatus API asynchronously
func (client *Client) GetSQLReviewCheckResultStatusWithCallback(request *GetSQLReviewCheckResultStatusRequest, callback func(response *GetSQLReviewCheckResultStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSQLReviewCheckResultStatusResponse
		var err error
		defer close(result)
		response, err = client.GetSQLReviewCheckResultStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSQLReviewCheckResultStatusRequest is the request struct for api GetSQLReviewCheckResultStatus
type GetSQLReviewCheckResultStatusRequest struct {
	*requests.RpcRequest
	OrderId         requests.Integer `position:"Query" name:"OrderId"`
	Tid             requests.Integer `position:"Query" name:"Tid"`
	OrderActionName string           `position:"Query" name:"OrderActionName"`
}

// GetSQLReviewCheckResultStatusResponse is the response struct for api GetSQLReviewCheckResultStatus
type GetSQLReviewCheckResultStatusResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ErrorCode         string            `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage      string            `json:"ErrorMessage" xml:"ErrorMessage"`
	Success           bool              `json:"Success" xml:"Success"`
	CheckResultStatus CheckResultStatus `json:"CheckResultStatus" xml:"CheckResultStatus"`
}

// CreateGetSQLReviewCheckResultStatusRequest creates a request to invoke GetSQLReviewCheckResultStatus API
func CreateGetSQLReviewCheckResultStatusRequest() (request *GetSQLReviewCheckResultStatusRequest) {
	request = &GetSQLReviewCheckResultStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetSQLReviewCheckResultStatus", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSQLReviewCheckResultStatusResponse creates a response to parse from GetSQLReviewCheckResultStatus response
func CreateGetSQLReviewCheckResultStatusResponse() (response *GetSQLReviewCheckResultStatusResponse) {
	response = &GetSQLReviewCheckResultStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
