package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceDasPro invokes the das.DescribeInstanceDasPro API synchronously
func (client *Client) DescribeInstanceDasPro(request *DescribeInstanceDasProRequest) (response *DescribeInstanceDasProResponse, err error) {
	response = CreateDescribeInstanceDasProResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceDasProWithChan invokes the das.DescribeInstanceDasPro API asynchronously
func (client *Client) DescribeInstanceDasProWithChan(request *DescribeInstanceDasProRequest) (<-chan *DescribeInstanceDasProResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceDasProResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceDasPro(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceDasProWithCallback invokes the das.DescribeInstanceDasPro API asynchronously
func (client *Client) DescribeInstanceDasProWithCallback(request *DescribeInstanceDasProRequest, callback func(response *DescribeInstanceDasProResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceDasProResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceDasPro(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceDasProRequest is the request struct for api DescribeInstanceDasPro
type DescribeInstanceDasProRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeInstanceDasProResponse is the response struct for api DescribeInstanceDasPro
type DescribeInstanceDasProResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateDescribeInstanceDasProRequest creates a request to invoke DescribeInstanceDasPro API
func CreateDescribeInstanceDasProRequest() (request *DescribeInstanceDasProRequest) {
	request = &DescribeInstanceDasProRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DescribeInstanceDasPro", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceDasProResponse creates a response to parse from DescribeInstanceDasPro response
func CreateDescribeInstanceDasProResponse() (response *DescribeInstanceDasProResponse) {
	response = &DescribeInstanceDasProResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
