package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainRealtimeLogDelivery invokes the cdn.DescribeDomainRealtimeLogDelivery API synchronously
func (client *Client) DescribeDomainRealtimeLogDelivery(request *DescribeDomainRealtimeLogDeliveryRequest) (response *DescribeDomainRealtimeLogDeliveryResponse, err error) {
	response = CreateDescribeDomainRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainRealtimeLogDeliveryWithChan invokes the cdn.DescribeDomainRealtimeLogDelivery API asynchronously
func (client *Client) DescribeDomainRealtimeLogDeliveryWithChan(request *DescribeDomainRealtimeLogDeliveryRequest) (<-chan *DescribeDomainRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainRealtimeLogDeliveryWithCallback invokes the cdn.DescribeDomainRealtimeLogDelivery API asynchronously
func (client *Client) DescribeDomainRealtimeLogDeliveryWithCallback(request *DescribeDomainRealtimeLogDeliveryRequest, callback func(response *DescribeDomainRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainRealtimeLogDeliveryRequest is the request struct for api DescribeDomainRealtimeLogDelivery
type DescribeDomainRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	Domain  string           `position:"Query" name:"Domain"`
}

// DescribeDomainRealtimeLogDeliveryResponse is the response struct for api DescribeDomainRealtimeLogDelivery
type DescribeDomainRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Project   string `json:"Project" xml:"Project"`
	Region    string `json:"Region" xml:"Region"`
	Logstore  string `json:"Logstore" xml:"Logstore"`
	Status    string `json:"Status" xml:"Status"`
}

// CreateDescribeDomainRealtimeLogDeliveryRequest creates a request to invoke DescribeDomainRealtimeLogDelivery API
func CreateDescribeDomainRealtimeLogDeliveryRequest() (request *DescribeDomainRealtimeLogDeliveryRequest) {
	request = &DescribeDomainRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeDomainRealtimeLogDelivery", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDomainRealtimeLogDeliveryResponse creates a response to parse from DescribeDomainRealtimeLogDelivery response
func CreateDescribeDomainRealtimeLogDeliveryResponse() (response *DescribeDomainRealtimeLogDeliveryResponse) {
	response = &DescribeDomainRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
