//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfcalendar?language=objc)
#[repr(C)]
pub struct CFCalendar {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFCalendar"]
    unsafe impl CFCalendar {}
);

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFCalendar {
    #[doc(alias = "CFCalendarGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFCalendarGetTypeID() -> CFTypeID;
        }
        unsafe { CFCalendarGetTypeID() }
    }
}

#[inline]
pub unsafe extern "C-unwind" fn CFCalendarCopyCurrent() -> Option<CFRetained<CFCalendar>> {
    extern "C-unwind" {
        fn CFCalendarCopyCurrent() -> Option<NonNull<CFCalendar>>;
    }
    let ret = unsafe { CFCalendarCopyCurrent() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Creates a calendar.  The identifiers are the `kCF*Calendar` constants in CFLocale.h.
#[cfg(all(feature = "CFBase", feature = "CFLocale"))]
#[inline]
pub unsafe extern "C-unwind" fn CFCalendarCreateWithIdentifier(
    allocator: Option<&CFAllocator>,
    identifier: Option<&CFCalendarIdentifier>,
) -> Option<CFRetained<CFCalendar>> {
    extern "C-unwind" {
        fn CFCalendarCreateWithIdentifier(
            allocator: Option<&CFAllocator>,
            identifier: Option<&CFCalendarIdentifier>,
        ) -> Option<NonNull<CFCalendar>>;
    }
    let ret = unsafe { CFCalendarCreateWithIdentifier(allocator, identifier) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Returns the calendar's identifier.
#[cfg(all(feature = "CFBase", feature = "CFLocale"))]
#[inline]
pub unsafe extern "C-unwind" fn CFCalendarGetIdentifier(
    calendar: &CFCalendar,
) -> Option<CFRetained<CFCalendarIdentifier>> {
    extern "C-unwind" {
        fn CFCalendarGetIdentifier(calendar: &CFCalendar) -> Option<NonNull<CFCalendarIdentifier>>;
    }
    let ret = unsafe { CFCalendarGetIdentifier(calendar) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFLocale")]
#[inline]
pub unsafe extern "C-unwind" fn CFCalendarCopyLocale(
    calendar: &CFCalendar,
) -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFCalendarCopyLocale(calendar: &CFCalendar) -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFCalendarCopyLocale(calendar) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFLocale")]
    pub fn CFCalendarSetLocale(calendar: &CFCalendar, locale: Option<&CFLocale>);
}

#[cfg(feature = "CFDate")]
#[inline]
pub unsafe extern "C-unwind" fn CFCalendarCopyTimeZone(
    calendar: &CFCalendar,
) -> Option<CFRetained<CFTimeZone>> {
    extern "C-unwind" {
        fn CFCalendarCopyTimeZone(calendar: &CFCalendar) -> Option<NonNull<CFTimeZone>>;
    }
    let ret = unsafe { CFCalendarCopyTimeZone(calendar) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFDate")]
    pub fn CFCalendarSetTimeZone(calendar: &CFCalendar, tz: Option<&CFTimeZone>);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFCalendarGetFirstWeekday(calendar: &CFCalendar) -> CFIndex;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFCalendarSetFirstWeekday(calendar: &CFCalendar, wkdy: CFIndex);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFCalendarGetMinimumDaysInFirstWeek(calendar: &CFCalendar) -> CFIndex;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFCalendarSetMinimumDaysInFirstWeek(calendar: &CFCalendar, mwd: CFIndex);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfcalendarunit?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFCalendarUnit(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFCalendarUnit: CFOptionFlags {
        #[doc(alias = "kCFCalendarUnitEra")]
        const Era = 1<<1;
        #[doc(alias = "kCFCalendarUnitYear")]
        const Year = 1<<2;
        #[doc(alias = "kCFCalendarUnitMonth")]
        const Month = 1<<3;
        #[doc(alias = "kCFCalendarUnitDay")]
        const Day = 1<<4;
        #[doc(alias = "kCFCalendarUnitHour")]
        const Hour = 1<<5;
        #[doc(alias = "kCFCalendarUnitMinute")]
        const Minute = 1<<6;
        #[doc(alias = "kCFCalendarUnitSecond")]
        const Second = 1<<7;
#[deprecated = "Use kCFCalendarUnitWeekOfYear or kCFCalendarUnitWeekOfMonth instead"]
        #[doc(alias = "kCFCalendarUnitWeek")]
        const Week = 1<<8;
        #[doc(alias = "kCFCalendarUnitWeekday")]
        const Weekday = 1<<9;
        #[doc(alias = "kCFCalendarUnitWeekdayOrdinal")]
        const WeekdayOrdinal = 1<<10;
        #[doc(alias = "kCFCalendarUnitQuarter")]
        const Quarter = 1<<11;
        #[doc(alias = "kCFCalendarUnitWeekOfMonth")]
        const WeekOfMonth = 1<<12;
        #[doc(alias = "kCFCalendarUnitWeekOfYear")]
        const WeekOfYear = 1<<13;
        #[doc(alias = "kCFCalendarUnitYearForWeekOfYear")]
        const YearForWeekOfYear = 1<<14;
        #[doc(alias = "kCFCalendarUnitDayOfYear")]
        const DayOfYear = 1<<16;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFCalendarUnit {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFCalendarUnit {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFCalendarGetMinimumRangeOfUnit(calendar: &CFCalendar, unit: CFCalendarUnit) -> CFRange;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFCalendarGetMaximumRangeOfUnit(calendar: &CFCalendar, unit: CFCalendarUnit) -> CFRange;
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFDate"))]
    pub fn CFCalendarGetRangeOfUnit(
        calendar: &CFCalendar,
        smaller_unit: CFCalendarUnit,
        bigger_unit: CFCalendarUnit,
        at: CFAbsoluteTime,
    ) -> CFRange;
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFDate"))]
    pub fn CFCalendarGetOrdinalityOfUnit(
        calendar: &CFCalendar,
        smaller_unit: CFCalendarUnit,
        bigger_unit: CFCalendarUnit,
        at: CFAbsoluteTime,
    ) -> CFIndex;
}

#[cfg(all(feature = "CFBase", feature = "CFDate"))]
#[inline]
pub unsafe extern "C-unwind" fn CFCalendarGetTimeRangeOfUnit(
    calendar: &CFCalendar,
    unit: CFCalendarUnit,
    at: CFAbsoluteTime,
    startp: *mut CFAbsoluteTime,
    tip: *mut CFTimeInterval,
) -> bool {
    extern "C-unwind" {
        fn CFCalendarGetTimeRangeOfUnit(
            calendar: &CFCalendar,
            unit: CFCalendarUnit,
            at: CFAbsoluteTime,
            startp: *mut CFAbsoluteTime,
            tip: *mut CFTimeInterval,
        ) -> Boolean;
    }
    let ret = unsafe { CFCalendarGetTimeRangeOfUnit(calendar, unit, at, startp, tip) };
    ret != 0
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfcalendarcomponentswrap?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFCalendarComponentsWrap: CFOptionFlags = 1 << 0;
