/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.io.File;
import jflex.core.Action;
import jflex.core.RegExp;
import jflex.core.RegExp1;
import jflex.core.RegExp2;
import jflex.core.RegExpException;
import jflex.core.RegExps;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;

public final class SemCheck {
    private SemCheck() {
    }

    public static void check(RegExps rs, File f) {
        int num = rs.getNum();
        for (int i = 0; i < num; ++i) {
            RegExp r = rs.getRegExp(i);
            RegExp l = rs.getLookAhead(i);
            Action a = rs.getAction(i);
            if (r == null || !SemCheck.maybeEmtpy(r)) continue;
            if (l != null) {
                if (a == null) {
                    Out.error(ErrorMessages.EMPTY_MATCH_LOOK);
                    continue;
                }
                Out.error(f, ErrorMessages.EMPTY_MATCH_LOOK, a.priority - 1, -1);
                continue;
            }
            if (a == null) {
                Out.warning(ErrorMessages.EMPTY_MATCH);
                continue;
            }
            Out.warning(f, ErrorMessages.EMPTY_MATCH, a.priority - 1, -1);
        }
    }

    public static boolean maybeEmtpy(RegExp re) {
        switch (re.type) {
            case 41: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.maybeEmtpy(r.r1) || SemCheck.maybeEmtpy(r.r2);
            }
            case 57: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.maybeEmtpy(r.r1) && SemCheck.maybeEmtpy(r.r2);
            }
            case 39: 
            case 42: {
                return true;
            }
            case 40: {
                RegExp1 r1 = (RegExp1)re;
                return SemCheck.maybeEmtpy((RegExp)r1.content);
            }
            case 46: 
            case 47: 
            case 55: 
            case 59: {
                return false;
            }
            case 48: 
            case 58: {
                String content = (String)((RegExp1)re).content;
                return content.length() == 0;
            }
            case 45: {
                RegExp1 r3 = (RegExp1)re;
                return !SemCheck.maybeEmtpy((RegExp)r3.content);
            }
        }
        throw new RegExpException(re);
    }

    public static int length(RegExp re) {
        switch (re.type) {
            case 41: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l1 == l2) {
                    return l1;
                }
                return -1;
            }
            case 57: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l2 < 0) {
                    return -1;
                }
                return l1 + l2;
            }
            case 39: 
            case 40: 
            case 42: {
                return -1;
            }
            case 47: 
            case 55: 
            case 59: {
                return 1;
            }
            case 48: 
            case 58: {
                String content = (String)((RegExp1)re).content;
                return content.length();
            }
            case 45: 
            case 46: {
                return -1;
            }
        }
        throw new RegExpException(re);
    }

    public static boolean isFiniteChoice(RegExp re) {
        switch (re.type) {
            case 41: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.isFiniteChoice(r.r1) && SemCheck.isFiniteChoice(r.r2);
            }
            case 57: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return false;
                }
                int l2 = SemCheck.length(r.r2);
                return l2 >= 0;
            }
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                return false;
            }
            case 47: 
            case 48: 
            case 55: 
            case 58: 
            case 59: {
                return true;
            }
        }
        throw new RegExpException(re);
    }
}

