// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A Personally Identifiable Information (PII) entity configured in a guardrail.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailPiiEntityFilter {
    /// <p>The PII entity filter match.</p>
    pub r#match: ::std::string::String,
    /// <p>The PII entity filter type.</p>
    pub r#type: crate::types::GuardrailPiiEntityType,
    /// <p>The PII entity filter action.</p>
    pub action: crate::types::GuardrailSensitiveInformationPolicyAction,
    /// <p>Indicates whether personally identifiable information (PII) that breaches the guardrail configuration is detected.</p>
    pub detected: ::std::option::Option<bool>,
}
impl GuardrailPiiEntityFilter {
    /// <p>The PII entity filter match.</p>
    pub fn r#match(&self) -> &str {
        use std::ops::Deref;
        self.r#match.deref()
    }
    /// <p>The PII entity filter type.</p>
    pub fn r#type(&self) -> &crate::types::GuardrailPiiEntityType {
        &self.r#type
    }
    /// <p>The PII entity filter action.</p>
    pub fn action(&self) -> &crate::types::GuardrailSensitiveInformationPolicyAction {
        &self.action
    }
    /// <p>Indicates whether personally identifiable information (PII) that breaches the guardrail configuration is detected.</p>
    pub fn detected(&self) -> ::std::option::Option<bool> {
        self.detected
    }
}
impl GuardrailPiiEntityFilter {
    /// Creates a new builder-style object to manufacture [`GuardrailPiiEntityFilter`](crate::types::GuardrailPiiEntityFilter).
    pub fn builder() -> crate::types::builders::GuardrailPiiEntityFilterBuilder {
        crate::types::builders::GuardrailPiiEntityFilterBuilder::default()
    }
}

/// A builder for [`GuardrailPiiEntityFilter`](crate::types::GuardrailPiiEntityFilter).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailPiiEntityFilterBuilder {
    pub(crate) r#match: ::std::option::Option<::std::string::String>,
    pub(crate) r#type: ::std::option::Option<crate::types::GuardrailPiiEntityType>,
    pub(crate) action: ::std::option::Option<crate::types::GuardrailSensitiveInformationPolicyAction>,
    pub(crate) detected: ::std::option::Option<bool>,
}
impl GuardrailPiiEntityFilterBuilder {
    /// <p>The PII entity filter match.</p>
    /// This field is required.
    pub fn r#match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.r#match = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The PII entity filter match.</p>
    pub fn set_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.r#match = input;
        self
    }
    /// <p>The PII entity filter match.</p>
    pub fn get_match(&self) -> &::std::option::Option<::std::string::String> {
        &self.r#match
    }
    /// <p>The PII entity filter type.</p>
    /// This field is required.
    pub fn r#type(mut self, input: crate::types::GuardrailPiiEntityType) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The PII entity filter type.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::GuardrailPiiEntityType>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The PII entity filter type.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::GuardrailPiiEntityType> {
        &self.r#type
    }
    /// <p>The PII entity filter action.</p>
    /// This field is required.
    pub fn action(mut self, input: crate::types::GuardrailSensitiveInformationPolicyAction) -> Self {
        self.action = ::std::option::Option::Some(input);
        self
    }
    /// <p>The PII entity filter action.</p>
    pub fn set_action(mut self, input: ::std::option::Option<crate::types::GuardrailSensitiveInformationPolicyAction>) -> Self {
        self.action = input;
        self
    }
    /// <p>The PII entity filter action.</p>
    pub fn get_action(&self) -> &::std::option::Option<crate::types::GuardrailSensitiveInformationPolicyAction> {
        &self.action
    }
    /// <p>Indicates whether personally identifiable information (PII) that breaches the guardrail configuration is detected.</p>
    pub fn detected(mut self, input: bool) -> Self {
        self.detected = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether personally identifiable information (PII) that breaches the guardrail configuration is detected.</p>
    pub fn set_detected(mut self, input: ::std::option::Option<bool>) -> Self {
        self.detected = input;
        self
    }
    /// <p>Indicates whether personally identifiable information (PII) that breaches the guardrail configuration is detected.</p>
    pub fn get_detected(&self) -> &::std::option::Option<bool> {
        &self.detected
    }
    /// Consumes the builder and constructs a [`GuardrailPiiEntityFilter`](crate::types::GuardrailPiiEntityFilter).
    /// This method will fail if any of the following fields are not set:
    /// - [`r#match`](crate::types::builders::GuardrailPiiEntityFilterBuilder::match)
    /// - [`r#type`](crate::types::builders::GuardrailPiiEntityFilterBuilder::type)
    /// - [`action`](crate::types::builders::GuardrailPiiEntityFilterBuilder::action)
    pub fn build(self) -> ::std::result::Result<crate::types::GuardrailPiiEntityFilter, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GuardrailPiiEntityFilter {
            r#match: self.r#match.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "r#match",
                    "r#match was not specified but it is required when building GuardrailPiiEntityFilter",
                )
            })?,
            r#type: self.r#type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "r#type",
                    "r#type was not specified but it is required when building GuardrailPiiEntityFilter",
                )
            })?,
            action: self.action.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "action",
                    "action was not specified but it is required when building GuardrailPiiEntityFilter",
                )
            })?,
            detected: self.detected,
        })
    }
}
