/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.data.gis.handlers.GISGeometryValueHandler;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueBinder;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class AltibaseGeometryValueHandler
extends GISGeometryValueHandler
implements DBDValueBinder {
    private static final Log log = Log.getLog(AltibaseGeometryValueHandler.class);
    public static final AltibaseGeometryValueHandler INSTANCE = new AltibaseGeometryValueHandler();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object object = resultSet.getObject(index);
        return this.getValueFromObject(session, type, object, false, false);
    }

    public DBGeometry getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        DBGeometry dbGeometry = null;
        int srid = 0;
        try {
            if (object == null) {
                return new DBGeometry();
            }
            if (object instanceof DBGeometry) {
                if (copy) {
                    return ((DBGeometry)object).copy();
                }
                return (DBGeometry)object;
            }
            if (object instanceof Geometry) {
                return new DBGeometry((Geometry)object);
            }
            Geometry geom = null;
            String[] content = ((String)object).split(";", 2);
            if (content.length == 2) {
                content[0] = content[0].replaceAll("SRID=", "");
                try {
                    srid = Integer.parseInt(content[0]);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Failed to parse SRID: " + String.valueOf(e)));
                }
                geom = new WKTReader().read(content[1]);
            } else if (content.length == 1) {
                geom = new WKTReader().read(content[0]);
            }
            dbGeometry = new DBGeometry(geom);
            dbGeometry.setSRID(srid);
        }
        catch (ParseException e) {
            log.warn((Object)("Failed to parse object: " + (object != null ? object.toString() : "NULL") + AltibaseConstants.NEW_LINE + e.getLocalizedMessage()));
        }
        return dbGeometry;
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        int srid = 0;
        Object attribute = null;
        Object rawValue = null;
        attribute = paramType instanceof DBDAttributeBinding ? ((DBDAttributeBinding)paramType).getAttribute() : paramType;
        if (value instanceof DBGeometry) {
            srid = ((DBGeometry)value).getSRID();
            rawValue = ((DBGeometry)value).getRawValue();
        } else {
            rawValue = value;
        }
        if (srid == 0 && attribute instanceof GisAttribute) {
            srid = ((GisAttribute)attribute).getAttributeGeometrySRID(session.getProgressMonitor());
        }
        if (rawValue == null) {
            statement.setNull(paramIndex, attribute.getTypeID());
        } else if (rawValue instanceof Geometry) {
            if (((Geometry)rawValue).getSRID() == 0) {
                ((Geometry)rawValue).setSRID(srid);
            }
            statement.setString(paramIndex, new WKTWriter(4).write((Geometry)rawValue));
        } else {
            Object strValue = rawValue.toString();
            if (srid != 0 && !((String)strValue).startsWith("SRID=")) {
                strValue = "SRID=" + srid + ";" + (String)strValue;
            }
            statement.setObject(paramIndex, strValue, 10003);
        }
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBGeometry) {
            int valueSRID = ((DBGeometry)value).getSRID();
            Object strValue = value.toString();
            if (valueSRID != 0 && !((String)strValue).startsWith("SRID=")) {
                strValue = "SRID=" + valueSRID + ";" + (String)strValue;
            }
            return strValue;
        }
        return super.getValueDisplayString(column, value, format);
    }

    public String makeQueryBind(DBSAttributeBase attribute, Object value) throws DBCException {
        return "GEOMFROMTEXT(?, " + ((DBGeometry)value).getSRID() + ")";
    }
}

