// Copyright 2020 Google LLC. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// THIS FILE IS AUTOMATICALLY GENERATED.

package discovery_v1

import (
	"fmt"
	"regexp"
	"strings"

	yaml "go.yaml.in/yaml/v3"

	"github.com/google/gnostic-models/compiler"
)

// Version returns the package name (and OpenAPI version).
func Version() string {
	return "discovery_v1"
}

// NewAnnotations creates an object of type Annotations if possible, returning an error if not.
func NewAnnotations(in *yaml.Node, context *compiler.Context) (*Annotations, error) {
	errors := make([]error, 0)
	x := &Annotations{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"required"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated string required = 1;
		v1 := compiler.MapValueForKey(m, "required")
		if v1 != nil {
			v, ok := compiler.SequenceNodeForNode(v1)
			if ok {
				x.Required = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for required: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewAny creates an object of type Any if possible, returning an error if not.
func NewAny(in *yaml.Node, context *compiler.Context) (*Any, error) {
	errors := make([]error, 0)
	x := &Any{}
	bytes := compiler.Marshal(in)
	x.Yaml = string(bytes)
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewAuth creates an object of type Auth if possible, returning an error if not.
func NewAuth(in *yaml.Node, context *compiler.Context) (*Auth, error) {
	errors := make([]error, 0)
	x := &Auth{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"oauth2"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// Oauth2 oauth2 = 1;
		v1 := compiler.MapValueForKey(m, "oauth2")
		if v1 != nil {
			var err error
			x.Oauth2, err = NewOauth2(v1, compiler.NewContext("oauth2", v1, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewDocument creates an object of type Document if possible, returning an error if not.
func NewDocument(in *yaml.Node, context *compiler.Context) (*Document, error) {
	errors := make([]error, 0)
	x := &Document{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"discoveryVersion", "kind"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"auth", "basePath", "baseUrl", "batchPath", "canonicalName", "description", "discoveryVersion", "documentationLink", "etag", "features", "fullyEncodeReservedExpansion", "icons", "id", "kind", "labels", "methods", "mtlsRootUrl", "name", "ownerDomain", "ownerName", "packagePath", "parameters", "protocol", "resources", "revision", "rootUrl", "schemas", "servicePath", "title", "version", "version_module"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string kind = 1;
		v1 := compiler.MapValueForKey(m, "kind")
		if v1 != nil {
			x.Kind, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for kind: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string discovery_version = 2;
		v2 := compiler.MapValueForKey(m, "discoveryVersion")
		if v2 != nil {
			x.DiscoveryVersion, ok = compiler.StringForScalarNode(v2)
			if !ok {
				message := fmt.Sprintf("has unexpected value for discoveryVersion: %s", compiler.Display(v2))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string id = 3;
		v3 := compiler.MapValueForKey(m, "id")
		if v3 != nil {
			x.Id, ok = compiler.StringForScalarNode(v3)
			if !ok {
				message := fmt.Sprintf("has unexpected value for id: %s", compiler.Display(v3))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string name = 4;
		v4 := compiler.MapValueForKey(m, "name")
		if v4 != nil {
			x.Name, ok = compiler.StringForScalarNode(v4)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %s", compiler.Display(v4))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string version = 5;
		v5 := compiler.MapValueForKey(m, "version")
		if v5 != nil {
			x.Version, ok = compiler.StringForScalarNode(v5)
			if !ok {
				message := fmt.Sprintf("has unexpected value for version: %s", compiler.Display(v5))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string revision = 6;
		v6 := compiler.MapValueForKey(m, "revision")
		if v6 != nil {
			x.Revision, ok = compiler.StringForScalarNode(v6)
			if !ok {
				message := fmt.Sprintf("has unexpected value for revision: %s", compiler.Display(v6))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string title = 7;
		v7 := compiler.MapValueForKey(m, "title")
		if v7 != nil {
			x.Title, ok = compiler.StringForScalarNode(v7)
			if !ok {
				message := fmt.Sprintf("has unexpected value for title: %s", compiler.Display(v7))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 8;
		v8 := compiler.MapValueForKey(m, "description")
		if v8 != nil {
			x.Description, ok = compiler.StringForScalarNode(v8)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %s", compiler.Display(v8))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Icons icons = 9;
		v9 := compiler.MapValueForKey(m, "icons")
		if v9 != nil {
			var err error
			x.Icons, err = NewIcons(v9, compiler.NewContext("icons", v9, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string documentation_link = 10;
		v10 := compiler.MapValueForKey(m, "documentationLink")
		if v10 != nil {
			x.DocumentationLink, ok = compiler.StringForScalarNode(v10)
			if !ok {
				message := fmt.Sprintf("has unexpected value for documentationLink: %s", compiler.Display(v10))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string labels = 11;
		v11 := compiler.MapValueForKey(m, "labels")
		if v11 != nil {
			v, ok := compiler.SequenceNodeForNode(v11)
			if ok {
				x.Labels = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for labels: %s", compiler.Display(v11))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string protocol = 12;
		v12 := compiler.MapValueForKey(m, "protocol")
		if v12 != nil {
			x.Protocol, ok = compiler.StringForScalarNode(v12)
			if !ok {
				message := fmt.Sprintf("has unexpected value for protocol: %s", compiler.Display(v12))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string base_url = 13;
		v13 := compiler.MapValueForKey(m, "baseUrl")
		if v13 != nil {
			x.BaseUrl, ok = compiler.StringForScalarNode(v13)
			if !ok {
				message := fmt.Sprintf("has unexpected value for baseUrl: %s", compiler.Display(v13))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string base_path = 14;
		v14 := compiler.MapValueForKey(m, "basePath")
		if v14 != nil {
			x.BasePath, ok = compiler.StringForScalarNode(v14)
			if !ok {
				message := fmt.Sprintf("has unexpected value for basePath: %s", compiler.Display(v14))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string root_url = 15;
		v15 := compiler.MapValueForKey(m, "rootUrl")
		if v15 != nil {
			x.RootUrl, ok = compiler.StringForScalarNode(v15)
			if !ok {
				message := fmt.Sprintf("has unexpected value for rootUrl: %s", compiler.Display(v15))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string service_path = 16;
		v16 := compiler.MapValueForKey(m, "servicePath")
		if v16 != nil {
			x.ServicePath, ok = compiler.StringForScalarNode(v16)
			if !ok {
				message := fmt.Sprintf("has unexpected value for servicePath: %s", compiler.Display(v16))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string batch_path = 17;
		v17 := compiler.MapValueForKey(m, "batchPath")
		if v17 != nil {
			x.BatchPath, ok = compiler.StringForScalarNode(v17)
			if !ok {
				message := fmt.Sprintf("has unexpected value for batchPath: %s", compiler.Display(v17))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Parameters parameters = 18;
		v18 := compiler.MapValueForKey(m, "parameters")
		if v18 != nil {
			var err error
			x.Parameters, err = NewParameters(v18, compiler.NewContext("parameters", v18, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Auth auth = 19;
		v19 := compiler.MapValueForKey(m, "auth")
		if v19 != nil {
			var err error
			x.Auth, err = NewAuth(v19, compiler.NewContext("auth", v19, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated string features = 20;
		v20 := compiler.MapValueForKey(m, "features")
		if v20 != nil {
			v, ok := compiler.SequenceNodeForNode(v20)
			if ok {
				x.Features = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for features: %s", compiler.Display(v20))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schemas schemas = 21;
		v21 := compiler.MapValueForKey(m, "schemas")
		if v21 != nil {
			var err error
			x.Schemas, err = NewSchemas(v21, compiler.NewContext("schemas", v21, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Methods methods = 22;
		v22 := compiler.MapValueForKey(m, "methods")
		if v22 != nil {
			var err error
			x.Methods, err = NewMethods(v22, compiler.NewContext("methods", v22, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Resources resources = 23;
		v23 := compiler.MapValueForKey(m, "resources")
		if v23 != nil {
			var err error
			x.Resources, err = NewResources(v23, compiler.NewContext("resources", v23, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string etag = 24;
		v24 := compiler.MapValueForKey(m, "etag")
		if v24 != nil {
			x.Etag, ok = compiler.StringForScalarNode(v24)
			if !ok {
				message := fmt.Sprintf("has unexpected value for etag: %s", compiler.Display(v24))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string owner_domain = 25;
		v25 := compiler.MapValueForKey(m, "ownerDomain")
		if v25 != nil {
			x.OwnerDomain, ok = compiler.StringForScalarNode(v25)
			if !ok {
				message := fmt.Sprintf("has unexpected value for ownerDomain: %s", compiler.Display(v25))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string owner_name = 26;
		v26 := compiler.MapValueForKey(m, "ownerName")
		if v26 != nil {
			x.OwnerName, ok = compiler.StringForScalarNode(v26)
			if !ok {
				message := fmt.Sprintf("has unexpected value for ownerName: %s", compiler.Display(v26))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool version_module = 27;
		v27 := compiler.MapValueForKey(m, "version_module")
		if v27 != nil {
			x.VersionModule, ok = compiler.BoolForScalarNode(v27)
			if !ok {
				message := fmt.Sprintf("has unexpected value for version_module: %s", compiler.Display(v27))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string canonical_name = 28;
		v28 := compiler.MapValueForKey(m, "canonicalName")
		if v28 != nil {
			x.CanonicalName, ok = compiler.StringForScalarNode(v28)
			if !ok {
				message := fmt.Sprintf("has unexpected value for canonicalName: %s", compiler.Display(v28))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool fully_encode_reserved_expansion = 29;
		v29 := compiler.MapValueForKey(m, "fullyEncodeReservedExpansion")
		if v29 != nil {
			x.FullyEncodeReservedExpansion, ok = compiler.BoolForScalarNode(v29)
			if !ok {
				message := fmt.Sprintf("has unexpected value for fullyEncodeReservedExpansion: %s", compiler.Display(v29))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string package_path = 30;
		v30 := compiler.MapValueForKey(m, "packagePath")
		if v30 != nil {
			x.PackagePath, ok = compiler.StringForScalarNode(v30)
			if !ok {
				message := fmt.Sprintf("has unexpected value for packagePath: %s", compiler.Display(v30))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string mtls_root_url = 31;
		v31 := compiler.MapValueForKey(m, "mtlsRootUrl")
		if v31 != nil {
			x.MtlsRootUrl, ok = compiler.StringForScalarNode(v31)
			if !ok {
				message := fmt.Sprintf("has unexpected value for mtlsRootUrl: %s", compiler.Display(v31))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewIcons creates an object of type Icons if possible, returning an error if not.
func NewIcons(in *yaml.Node, context *compiler.Context) (*Icons, error) {
	errors := make([]error, 0)
	x := &Icons{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"x16", "x32"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"x16", "x32"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string x16 = 1;
		v1 := compiler.MapValueForKey(m, "x16")
		if v1 != nil {
			x.X16, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for x16: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string x32 = 2;
		v2 := compiler.MapValueForKey(m, "x32")
		if v2 != nil {
			x.X32, ok = compiler.StringForScalarNode(v2)
			if !ok {
				message := fmt.Sprintf("has unexpected value for x32: %s", compiler.Display(v2))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewMediaUpload creates an object of type MediaUpload if possible, returning an error if not.
func NewMediaUpload(in *yaml.Node, context *compiler.Context) (*MediaUpload, error) {
	errors := make([]error, 0)
	x := &MediaUpload{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"accept", "maxSize", "protocols", "supportsSubscription"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated string accept = 1;
		v1 := compiler.MapValueForKey(m, "accept")
		if v1 != nil {
			v, ok := compiler.SequenceNodeForNode(v1)
			if ok {
				x.Accept = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for accept: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string max_size = 2;
		v2 := compiler.MapValueForKey(m, "maxSize")
		if v2 != nil {
			x.MaxSize, ok = compiler.StringForScalarNode(v2)
			if !ok {
				message := fmt.Sprintf("has unexpected value for maxSize: %s", compiler.Display(v2))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Protocols protocols = 3;
		v3 := compiler.MapValueForKey(m, "protocols")
		if v3 != nil {
			var err error
			x.Protocols, err = NewProtocols(v3, compiler.NewContext("protocols", v3, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool supports_subscription = 4;
		v4 := compiler.MapValueForKey(m, "supportsSubscription")
		if v4 != nil {
			x.SupportsSubscription, ok = compiler.BoolForScalarNode(v4)
			if !ok {
				message := fmt.Sprintf("has unexpected value for supportsSubscription: %s", compiler.Display(v4))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewMethod creates an object of type Method if possible, returning an error if not.
func NewMethod(in *yaml.Node, context *compiler.Context) (*Method, error) {
	errors := make([]error, 0)
	x := &Method{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"description", "etagRequired", "flatPath", "httpMethod", "id", "mediaUpload", "parameterOrder", "parameters", "path", "request", "response", "scopes", "streamingType", "supportsMediaDownload", "supportsMediaUpload", "supportsSubscription", "useMediaDownloadService"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string id = 1;
		v1 := compiler.MapValueForKey(m, "id")
		if v1 != nil {
			x.Id, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for id: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string path = 2;
		v2 := compiler.MapValueForKey(m, "path")
		if v2 != nil {
			x.Path, ok = compiler.StringForScalarNode(v2)
			if !ok {
				message := fmt.Sprintf("has unexpected value for path: %s", compiler.Display(v2))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string http_method = 3;
		v3 := compiler.MapValueForKey(m, "httpMethod")
		if v3 != nil {
			x.HttpMethod, ok = compiler.StringForScalarNode(v3)
			if !ok {
				message := fmt.Sprintf("has unexpected value for httpMethod: %s", compiler.Display(v3))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 4;
		v4 := compiler.MapValueForKey(m, "description")
		if v4 != nil {
			x.Description, ok = compiler.StringForScalarNode(v4)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %s", compiler.Display(v4))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Parameters parameters = 5;
		v5 := compiler.MapValueForKey(m, "parameters")
		if v5 != nil {
			var err error
			x.Parameters, err = NewParameters(v5, compiler.NewContext("parameters", v5, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated string parameter_order = 6;
		v6 := compiler.MapValueForKey(m, "parameterOrder")
		if v6 != nil {
			v, ok := compiler.SequenceNodeForNode(v6)
			if ok {
				x.ParameterOrder = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for parameterOrder: %s", compiler.Display(v6))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Request request = 7;
		v7 := compiler.MapValueForKey(m, "request")
		if v7 != nil {
			var err error
			x.Request, err = NewRequest(v7, compiler.NewContext("request", v7, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Response response = 8;
		v8 := compiler.MapValueForKey(m, "response")
		if v8 != nil {
			var err error
			x.Response, err = NewResponse(v8, compiler.NewContext("response", v8, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated string scopes = 9;
		v9 := compiler.MapValueForKey(m, "scopes")
		if v9 != nil {
			v, ok := compiler.SequenceNodeForNode(v9)
			if ok {
				x.Scopes = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for scopes: %s", compiler.Display(v9))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool supports_media_download = 10;
		v10 := compiler.MapValueForKey(m, "supportsMediaDownload")
		if v10 != nil {
			x.SupportsMediaDownload, ok = compiler.BoolForScalarNode(v10)
			if !ok {
				message := fmt.Sprintf("has unexpected value for supportsMediaDownload: %s", compiler.Display(v10))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool supports_media_upload = 11;
		v11 := compiler.MapValueForKey(m, "supportsMediaUpload")
		if v11 != nil {
			x.SupportsMediaUpload, ok = compiler.BoolForScalarNode(v11)
			if !ok {
				message := fmt.Sprintf("has unexpected value for supportsMediaUpload: %s", compiler.Display(v11))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool use_media_download_service = 12;
		v12 := compiler.MapValueForKey(m, "useMediaDownloadService")
		if v12 != nil {
			x.UseMediaDownloadService, ok = compiler.BoolForScalarNode(v12)
			if !ok {
				message := fmt.Sprintf("has unexpected value for useMediaDownloadService: %s", compiler.Display(v12))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// MediaUpload media_upload = 13;
		v13 := compiler.MapValueForKey(m, "mediaUpload")
		if v13 != nil {
			var err error
			x.MediaUpload, err = NewMediaUpload(v13, compiler.NewContext("mediaUpload", v13, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool supports_subscription = 14;
		v14 := compiler.MapValueForKey(m, "supportsSubscription")
		if v14 != nil {
			x.SupportsSubscription, ok = compiler.BoolForScalarNode(v14)
			if !ok {
				message := fmt.Sprintf("has unexpected value for supportsSubscription: %s", compiler.Display(v14))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string flat_path = 15;
		v15 := compiler.MapValueForKey(m, "flatPath")
		if v15 != nil {
			x.FlatPath, ok = compiler.StringForScalarNode(v15)
			if !ok {
				message := fmt.Sprintf("has unexpected value for flatPath: %s", compiler.Display(v15))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool etag_required = 16;
		v16 := compiler.MapValueForKey(m, "etagRequired")
		if v16 != nil {
			x.EtagRequired, ok = compiler.BoolForScalarNode(v16)
			if !ok {
				message := fmt.Sprintf("has unexpected value for etagRequired: %s", compiler.Display(v16))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string streaming_type = 17;
		v17 := compiler.MapValueForKey(m, "streamingType")
		if v17 != nil {
			x.StreamingType, ok = compiler.StringForScalarNode(v17)
			if !ok {
				message := fmt.Sprintf("has unexpected value for streamingType: %s", compiler.Display(v17))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewMethods creates an object of type Methods if possible, returning an error if not.
func NewMethods(in *yaml.Node, context *compiler.Context) (*Methods, error) {
	errors := make([]error, 0)
	x := &Methods{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedMethod additional_properties = 1;
		// MAP: Method
		x.AdditionalProperties = make([]*NamedMethod, 0)
		for i := 0; i < len(m.Content); i += 2 {
			k, ok := compiler.StringForScalarNode(m.Content[i])
			if ok {
				v := m.Content[i+1]
				pair := &NamedMethod{}
				pair.Name = k
				var err error
				pair.Value, err = NewMethod(v, compiler.NewContext(k, v, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedMethod creates an object of type NamedMethod if possible, returning an error if not.
func NewNamedMethod(in *yaml.Node, context *compiler.Context) (*NamedMethod, error) {
	errors := make([]error, 0)
	x := &NamedMethod{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Method value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewMethod(v2, compiler.NewContext("value", v2, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedParameter creates an object of type NamedParameter if possible, returning an error if not.
func NewNamedParameter(in *yaml.Node, context *compiler.Context) (*NamedParameter, error) {
	errors := make([]error, 0)
	x := &NamedParameter{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Parameter value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewParameter(v2, compiler.NewContext("value", v2, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedResource creates an object of type NamedResource if possible, returning an error if not.
func NewNamedResource(in *yaml.Node, context *compiler.Context) (*NamedResource, error) {
	errors := make([]error, 0)
	x := &NamedResource{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Resource value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewResource(v2, compiler.NewContext("value", v2, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedSchema creates an object of type NamedSchema if possible, returning an error if not.
func NewNamedSchema(in *yaml.Node, context *compiler.Context) (*NamedSchema, error) {
	errors := make([]error, 0)
	x := &NamedSchema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schema value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewSchema(v2, compiler.NewContext("value", v2, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedScope creates an object of type NamedScope if possible, returning an error if not.
func NewNamedScope(in *yaml.Node, context *compiler.Context) (*NamedScope, error) {
	errors := make([]error, 0)
	x := &NamedScope{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Scope value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewScope(v2, compiler.NewContext("value", v2, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOauth2 creates an object of type Oauth2 if possible, returning an error if not.
func NewOauth2(in *yaml.Node, context *compiler.Context) (*Oauth2, error) {
	errors := make([]error, 0)
	x := &Oauth2{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"scopes"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// Scopes scopes = 1;
		v1 := compiler.MapValueForKey(m, "scopes")
		if v1 != nil {
			var err error
			x.Scopes, err = NewScopes(v1, compiler.NewContext("scopes", v1, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParameter creates an object of type Parameter if possible, returning an error if not.
func NewParameter(in *yaml.Node, context *compiler.Context) (*Parameter, error) {
	errors := make([]error, 0)
	x := &Parameter{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref", "additionalProperties", "annotations", "default", "description", "enum", "enumDescriptions", "format", "id", "items", "location", "maximum", "minimum", "pattern", "properties", "repeated", "required", "type"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string id = 1;
		v1 := compiler.MapValueForKey(m, "id")
		if v1 != nil {
			x.Id, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for id: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string type = 2;
		v2 := compiler.MapValueForKey(m, "type")
		if v2 != nil {
			x.Type, ok = compiler.StringForScalarNode(v2)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %s", compiler.Display(v2))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string _ref = 3;
		v3 := compiler.MapValueForKey(m, "$ref")
		if v3 != nil {
			x.XRef, ok = compiler.StringForScalarNode(v3)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %s", compiler.Display(v3))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 4;
		v4 := compiler.MapValueForKey(m, "description")
		if v4 != nil {
			x.Description, ok = compiler.StringForScalarNode(v4)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %s", compiler.Display(v4))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string default = 5;
		v5 := compiler.MapValueForKey(m, "default")
		if v5 != nil {
			x.Default, ok = compiler.StringForScalarNode(v5)
			if !ok {
				message := fmt.Sprintf("has unexpected value for default: %s", compiler.Display(v5))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool required = 6;
		v6 := compiler.MapValueForKey(m, "required")
		if v6 != nil {
			x.Required, ok = compiler.BoolForScalarNode(v6)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %s", compiler.Display(v6))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 7;
		v7 := compiler.MapValueForKey(m, "format")
		if v7 != nil {
			x.Format, ok = compiler.StringForScalarNode(v7)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %s", compiler.Display(v7))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 8;
		v8 := compiler.MapValueForKey(m, "pattern")
		if v8 != nil {
			x.Pattern, ok = compiler.StringForScalarNode(v8)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %s", compiler.Display(v8))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string minimum = 9;
		v9 := compiler.MapValueForKey(m, "minimum")
		if v9 != nil {
			x.Minimum, ok = compiler.StringForScalarNode(v9)
			if !ok {
				message := fmt.Sprintf("has unexpected value for minimum: %s", compiler.Display(v9))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string maximum = 10;
		v10 := compiler.MapValueForKey(m, "maximum")
		if v10 != nil {
			x.Maximum, ok = compiler.StringForScalarNode(v10)
			if !ok {
				message := fmt.Sprintf("has unexpected value for maximum: %s", compiler.Display(v10))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string enum = 11;
		v11 := compiler.MapValueForKey(m, "enum")
		if v11 != nil {
			v, ok := compiler.SequenceNodeForNode(v11)
			if ok {
				x.Enum = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for enum: %s", compiler.Display(v11))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string enum_descriptions = 12;
		v12 := compiler.MapValueForKey(m, "enumDescriptions")
		if v12 != nil {
			v, ok := compiler.SequenceNodeForNode(v12)
			if ok {
				x.EnumDescriptions = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for enumDescriptions: %s", compiler.Display(v12))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool repeated = 13;
		v13 := compiler.MapValueForKey(m, "repeated")
		if v13 != nil {
			x.Repeated, ok = compiler.BoolForScalarNode(v13)
			if !ok {
				message := fmt.Sprintf("has unexpected value for repeated: %s", compiler.Display(v13))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string location = 14;
		v14 := compiler.MapValueForKey(m, "location")
		if v14 != nil {
			x.Location, ok = compiler.StringForScalarNode(v14)
			if !ok {
				message := fmt.Sprintf("has unexpected value for location: %s", compiler.Display(v14))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schemas properties = 15;
		v15 := compiler.MapValueForKey(m, "properties")
		if v15 != nil {
			var err error
			x.Properties, err = NewSchemas(v15, compiler.NewContext("properties", v15, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Schema additional_properties = 16;
		v16 := compiler.MapValueForKey(m, "additionalProperties")
		if v16 != nil {
			var err error
			x.AdditionalProperties, err = NewSchema(v16, compiler.NewContext("additionalProperties", v16, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Schema items = 17;
		v17 := compiler.MapValueForKey(m, "items")
		if v17 != nil {
			var err error
			x.Items, err = NewSchema(v17, compiler.NewContext("items", v17, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Annotations annotations = 18;
		v18 := compiler.MapValueForKey(m, "annotations")
		if v18 != nil {
			var err error
			x.Annotations, err = NewAnnotations(v18, compiler.NewContext("annotations", v18, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParameters creates an object of type Parameters if possible, returning an error if not.
func NewParameters(in *yaml.Node, context *compiler.Context) (*Parameters, error) {
	errors := make([]error, 0)
	x := &Parameters{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedParameter additional_properties = 1;
		// MAP: Parameter
		x.AdditionalProperties = make([]*NamedParameter, 0)
		for i := 0; i < len(m.Content); i += 2 {
			k, ok := compiler.StringForScalarNode(m.Content[i])
			if ok {
				v := m.Content[i+1]
				pair := &NamedParameter{}
				pair.Name = k
				var err error
				pair.Value, err = NewParameter(v, compiler.NewContext(k, v, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewProtocols creates an object of type Protocols if possible, returning an error if not.
func NewProtocols(in *yaml.Node, context *compiler.Context) (*Protocols, error) {
	errors := make([]error, 0)
	x := &Protocols{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"resumable", "simple"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// Simple simple = 1;
		v1 := compiler.MapValueForKey(m, "simple")
		if v1 != nil {
			var err error
			x.Simple, err = NewSimple(v1, compiler.NewContext("simple", v1, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Resumable resumable = 2;
		v2 := compiler.MapValueForKey(m, "resumable")
		if v2 != nil {
			var err error
			x.Resumable, err = NewResumable(v2, compiler.NewContext("resumable", v2, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewRequest creates an object of type Request if possible, returning an error if not.
func NewRequest(in *yaml.Node, context *compiler.Context) (*Request, error) {
	errors := make([]error, 0)
	x := &Request{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref", "parameterName"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string _ref = 1;
		v1 := compiler.MapValueForKey(m, "$ref")
		if v1 != nil {
			x.XRef, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string parameter_name = 2;
		v2 := compiler.MapValueForKey(m, "parameterName")
		if v2 != nil {
			x.ParameterName, ok = compiler.StringForScalarNode(v2)
			if !ok {
				message := fmt.Sprintf("has unexpected value for parameterName: %s", compiler.Display(v2))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResource creates an object of type Resource if possible, returning an error if not.
func NewResource(in *yaml.Node, context *compiler.Context) (*Resource, error) {
	errors := make([]error, 0)
	x := &Resource{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"methods", "resources"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// Methods methods = 1;
		v1 := compiler.MapValueForKey(m, "methods")
		if v1 != nil {
			var err error
			x.Methods, err = NewMethods(v1, compiler.NewContext("methods", v1, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Resources resources = 2;
		v2 := compiler.MapValueForKey(m, "resources")
		if v2 != nil {
			var err error
			x.Resources, err = NewResources(v2, compiler.NewContext("resources", v2, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResources creates an object of type Resources if possible, returning an error if not.
func NewResources(in *yaml.Node, context *compiler.Context) (*Resources, error) {
	errors := make([]error, 0)
	x := &Resources{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedResource additional_properties = 1;
		// MAP: Resource
		x.AdditionalProperties = make([]*NamedResource, 0)
		for i := 0; i < len(m.Content); i += 2 {
			k, ok := compiler.StringForScalarNode(m.Content[i])
			if ok {
				v := m.Content[i+1]
				pair := &NamedResource{}
				pair.Name = k
				var err error
				pair.Value, err = NewResource(v, compiler.NewContext(k, v, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponse creates an object of type Response if possible, returning an error if not.
func NewResponse(in *yaml.Node, context *compiler.Context) (*Response, error) {
	errors := make([]error, 0)
	x := &Response{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string _ref = 1;
		v1 := compiler.MapValueForKey(m, "$ref")
		if v1 != nil {
			x.XRef, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResumable creates an object of type Resumable if possible, returning an error if not.
func NewResumable(in *yaml.Node, context *compiler.Context) (*Resumable, error) {
	errors := make([]error, 0)
	x := &Resumable{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"multipart", "path"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// bool multipart = 1;
		v1 := compiler.MapValueForKey(m, "multipart")
		if v1 != nil {
			x.Multipart, ok = compiler.BoolForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for multipart: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string path = 2;
		v2 := compiler.MapValueForKey(m, "path")
		if v2 != nil {
			x.Path, ok = compiler.StringForScalarNode(v2)
			if !ok {
				message := fmt.Sprintf("has unexpected value for path: %s", compiler.Display(v2))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSchema creates an object of type Schema if possible, returning an error if not.
func NewSchema(in *yaml.Node, context *compiler.Context) (*Schema, error) {
	errors := make([]error, 0)
	x := &Schema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref", "additionalProperties", "annotations", "default", "description", "enum", "enumDescriptions", "format", "id", "items", "location", "maximum", "minimum", "pattern", "properties", "readOnly", "repeated", "required", "type"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string id = 1;
		v1 := compiler.MapValueForKey(m, "id")
		if v1 != nil {
			x.Id, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for id: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string type = 2;
		v2 := compiler.MapValueForKey(m, "type")
		if v2 != nil {
			x.Type, ok = compiler.StringForScalarNode(v2)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %s", compiler.Display(v2))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = compiler.StringForScalarNode(v3)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %s", compiler.Display(v3))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string default = 4;
		v4 := compiler.MapValueForKey(m, "default")
		if v4 != nil {
			x.Default, ok = compiler.StringForScalarNode(v4)
			if !ok {
				message := fmt.Sprintf("has unexpected value for default: %s", compiler.Display(v4))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool required = 5;
		v5 := compiler.MapValueForKey(m, "required")
		if v5 != nil {
			x.Required, ok = compiler.BoolForScalarNode(v5)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %s", compiler.Display(v5))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 6;
		v6 := compiler.MapValueForKey(m, "format")
		if v6 != nil {
			x.Format, ok = compiler.StringForScalarNode(v6)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %s", compiler.Display(v6))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 7;
		v7 := compiler.MapValueForKey(m, "pattern")
		if v7 != nil {
			x.Pattern, ok = compiler.StringForScalarNode(v7)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %s", compiler.Display(v7))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string minimum = 8;
		v8 := compiler.MapValueForKey(m, "minimum")
		if v8 != nil {
			x.Minimum, ok = compiler.StringForScalarNode(v8)
			if !ok {
				message := fmt.Sprintf("has unexpected value for minimum: %s", compiler.Display(v8))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string maximum = 9;
		v9 := compiler.MapValueForKey(m, "maximum")
		if v9 != nil {
			x.Maximum, ok = compiler.StringForScalarNode(v9)
			if !ok {
				message := fmt.Sprintf("has unexpected value for maximum: %s", compiler.Display(v9))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string enum = 10;
		v10 := compiler.MapValueForKey(m, "enum")
		if v10 != nil {
			v, ok := compiler.SequenceNodeForNode(v10)
			if ok {
				x.Enum = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for enum: %s", compiler.Display(v10))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string enum_descriptions = 11;
		v11 := compiler.MapValueForKey(m, "enumDescriptions")
		if v11 != nil {
			v, ok := compiler.SequenceNodeForNode(v11)
			if ok {
				x.EnumDescriptions = compiler.StringArrayForSequenceNode(v)
			} else {
				message := fmt.Sprintf("has unexpected value for enumDescriptions: %s", compiler.Display(v11))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool repeated = 12;
		v12 := compiler.MapValueForKey(m, "repeated")
		if v12 != nil {
			x.Repeated, ok = compiler.BoolForScalarNode(v12)
			if !ok {
				message := fmt.Sprintf("has unexpected value for repeated: %s", compiler.Display(v12))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string location = 13;
		v13 := compiler.MapValueForKey(m, "location")
		if v13 != nil {
			x.Location, ok = compiler.StringForScalarNode(v13)
			if !ok {
				message := fmt.Sprintf("has unexpected value for location: %s", compiler.Display(v13))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schemas properties = 14;
		v14 := compiler.MapValueForKey(m, "properties")
		if v14 != nil {
			var err error
			x.Properties, err = NewSchemas(v14, compiler.NewContext("properties", v14, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Schema additional_properties = 15;
		v15 := compiler.MapValueForKey(m, "additionalProperties")
		if v15 != nil {
			var err error
			x.AdditionalProperties, err = NewSchema(v15, compiler.NewContext("additionalProperties", v15, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Schema items = 16;
		v16 := compiler.MapValueForKey(m, "items")
		if v16 != nil {
			var err error
			x.Items, err = NewSchema(v16, compiler.NewContext("items", v16, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string _ref = 17;
		v17 := compiler.MapValueForKey(m, "$ref")
		if v17 != nil {
			x.XRef, ok = compiler.StringForScalarNode(v17)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %s", compiler.Display(v17))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Annotations annotations = 18;
		v18 := compiler.MapValueForKey(m, "annotations")
		if v18 != nil {
			var err error
			x.Annotations, err = NewAnnotations(v18, compiler.NewContext("annotations", v18, context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool read_only = 19;
		v19 := compiler.MapValueForKey(m, "readOnly")
		if v19 != nil {
			x.ReadOnly, ok = compiler.BoolForScalarNode(v19)
			if !ok {
				message := fmt.Sprintf("has unexpected value for readOnly: %s", compiler.Display(v19))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSchemas creates an object of type Schemas if possible, returning an error if not.
func NewSchemas(in *yaml.Node, context *compiler.Context) (*Schemas, error) {
	errors := make([]error, 0)
	x := &Schemas{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedSchema additional_properties = 1;
		// MAP: Schema
		x.AdditionalProperties = make([]*NamedSchema, 0)
		for i := 0; i < len(m.Content); i += 2 {
			k, ok := compiler.StringForScalarNode(m.Content[i])
			if ok {
				v := m.Content[i+1]
				pair := &NamedSchema{}
				pair.Name = k
				var err error
				pair.Value, err = NewSchema(v, compiler.NewContext(k, v, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewScope creates an object of type Scope if possible, returning an error if not.
func NewScope(in *yaml.Node, context *compiler.Context) (*Scope, error) {
	errors := make([]error, 0)
	x := &Scope{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"description"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string description = 1;
		v1 := compiler.MapValueForKey(m, "description")
		if v1 != nil {
			x.Description, ok = compiler.StringForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewScopes creates an object of type Scopes if possible, returning an error if not.
func NewScopes(in *yaml.Node, context *compiler.Context) (*Scopes, error) {
	errors := make([]error, 0)
	x := &Scopes{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedScope additional_properties = 1;
		// MAP: Scope
		x.AdditionalProperties = make([]*NamedScope, 0)
		for i := 0; i < len(m.Content); i += 2 {
			k, ok := compiler.StringForScalarNode(m.Content[i])
			if ok {
				v := m.Content[i+1]
				pair := &NamedScope{}
				pair.Name = k
				var err error
				pair.Value, err = NewScope(v, compiler.NewContext(k, v, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSimple creates an object of type Simple if possible, returning an error if not.
func NewSimple(in *yaml.Node, context *compiler.Context) (*Simple, error) {
	errors := make([]error, 0)
	x := &Simple{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"multipart", "path"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// bool multipart = 1;
		v1 := compiler.MapValueForKey(m, "multipart")
		if v1 != nil {
			x.Multipart, ok = compiler.BoolForScalarNode(v1)
			if !ok {
				message := fmt.Sprintf("has unexpected value for multipart: %s", compiler.Display(v1))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string path = 2;
		v2 := compiler.MapValueForKey(m, "path")
		if v2 != nil {
			x.Path, ok = compiler.StringForScalarNode(v2)
			if !ok {
				message := fmt.Sprintf("has unexpected value for path: %s", compiler.Display(v2))
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewStringArray creates an object of type StringArray if possible, returning an error if not.
func NewStringArray(in *yaml.Node, context *compiler.Context) (*StringArray, error) {
	errors := make([]error, 0)
	x := &StringArray{}
	x.Value = make([]string, 0)
	for _, node := range in.Content {
		s, _ := compiler.StringForScalarNode(node)
		x.Value = append(x.Value, s)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Annotations objects.
func (m *Annotations) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Any objects.
func (m *Any) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Auth objects.
func (m *Auth) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Oauth2 != nil {
		_, err := m.Oauth2.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Document objects.
func (m *Document) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Icons != nil {
		_, err := m.Icons.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Parameters != nil {
		_, err := m.Parameters.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Auth != nil {
		_, err := m.Auth.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Schemas != nil {
		_, err := m.Schemas.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Methods != nil {
		_, err := m.Methods.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Resources != nil {
		_, err := m.Resources.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Icons objects.
func (m *Icons) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside MediaUpload objects.
func (m *MediaUpload) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Protocols != nil {
		_, err := m.Protocols.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Method objects.
func (m *Method) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Parameters != nil {
		_, err := m.Parameters.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Request != nil {
		_, err := m.Request.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Response != nil {
		_, err := m.Response.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.MediaUpload != nil {
		_, err := m.MediaUpload.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Methods objects.
func (m *Methods) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedMethod objects.
func (m *NamedMethod) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedParameter objects.
func (m *NamedParameter) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedResource objects.
func (m *NamedResource) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedSchema objects.
func (m *NamedSchema) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedScope objects.
func (m *NamedScope) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Oauth2 objects.
func (m *Oauth2) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Scopes != nil {
		_, err := m.Scopes.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Parameter objects.
func (m *Parameter) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewParameter(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	if m.Properties != nil {
		_, err := m.Properties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.AdditionalProperties != nil {
		_, err := m.AdditionalProperties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Annotations != nil {
		_, err := m.Annotations.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Parameters objects.
func (m *Parameters) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Protocols objects.
func (m *Protocols) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Simple != nil {
		_, err := m.Simple.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Resumable != nil {
		_, err := m.Resumable.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Request objects.
func (m *Request) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewRequest(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Resource objects.
func (m *Resource) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Methods != nil {
		_, err := m.Methods.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Resources != nil {
		_, err := m.Resources.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Resources objects.
func (m *Resources) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Response objects.
func (m *Response) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		return info, nil
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Resumable objects.
func (m *Resumable) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Schema objects.
func (m *Schema) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	if m.Properties != nil {
		_, err := m.Properties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.AdditionalProperties != nil {
		_, err := m.AdditionalProperties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewSchema(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	if m.Annotations != nil {
		_, err := m.Annotations.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Schemas objects.
func (m *Schemas) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Scope objects.
func (m *Scope) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Scopes objects.
func (m *Scopes) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Simple objects.
func (m *Simple) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside StringArray objects.
func (m *StringArray) ResolveReferences(root string) (*yaml.Node, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ToRawInfo returns a description of Annotations suitable for JSON or YAML export.
func (m *Annotations) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if len(m.Required) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("required"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.Required))
	}
	return info
}

// ToRawInfo returns a description of Any suitable for JSON or YAML export.
func (m *Any) ToRawInfo() *yaml.Node {
	var err error
	var node yaml.Node
	err = yaml.Unmarshal([]byte(m.Yaml), &node)
	if err == nil {
		if node.Kind == yaml.DocumentNode {
			return node.Content[0]
		}
		return &node
	}
	return compiler.NewNullNode()
}

// ToRawInfo returns a description of Auth suitable for JSON or YAML export.
func (m *Auth) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Oauth2 != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("oauth2"))
		info.Content = append(info.Content, m.Oauth2.ToRawInfo())
	}
	return info
}

// ToRawInfo returns a description of Document suitable for JSON or YAML export.
func (m *Document) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	// always include this required field.
	info.Content = append(info.Content, compiler.NewScalarNodeForString("kind"))
	info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Kind))
	// always include this required field.
	info.Content = append(info.Content, compiler.NewScalarNodeForString("discoveryVersion"))
	info.Content = append(info.Content, compiler.NewScalarNodeForString(m.DiscoveryVersion))
	if m.Id != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("id"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Id))
	}
	if m.Name != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("name"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Name))
	}
	if m.Version != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("version"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Version))
	}
	if m.Revision != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("revision"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Revision))
	}
	if m.Title != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("title"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Title))
	}
	if m.Description != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("description"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Description))
	}
	if m.Icons != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("icons"))
		info.Content = append(info.Content, m.Icons.ToRawInfo())
	}
	if m.DocumentationLink != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("documentationLink"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.DocumentationLink))
	}
	if len(m.Labels) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("labels"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.Labels))
	}
	if m.Protocol != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("protocol"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Protocol))
	}
	if m.BaseUrl != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("baseUrl"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.BaseUrl))
	}
	if m.BasePath != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("basePath"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.BasePath))
	}
	if m.RootUrl != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("rootUrl"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.RootUrl))
	}
	if m.ServicePath != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("servicePath"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.ServicePath))
	}
	if m.BatchPath != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("batchPath"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.BatchPath))
	}
	if m.Parameters != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("parameters"))
		info.Content = append(info.Content, m.Parameters.ToRawInfo())
	}
	if m.Auth != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("auth"))
		info.Content = append(info.Content, m.Auth.ToRawInfo())
	}
	if len(m.Features) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("features"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.Features))
	}
	if m.Schemas != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("schemas"))
		info.Content = append(info.Content, m.Schemas.ToRawInfo())
	}
	if m.Methods != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("methods"))
		info.Content = append(info.Content, m.Methods.ToRawInfo())
	}
	if m.Resources != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("resources"))
		info.Content = append(info.Content, m.Resources.ToRawInfo())
	}
	if m.Etag != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("etag"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Etag))
	}
	if m.OwnerDomain != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("ownerDomain"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.OwnerDomain))
	}
	if m.OwnerName != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("ownerName"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.OwnerName))
	}
	if m.VersionModule {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("version_module"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.VersionModule))
	}
	if m.CanonicalName != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("canonicalName"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.CanonicalName))
	}
	if m.FullyEncodeReservedExpansion {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("fullyEncodeReservedExpansion"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.FullyEncodeReservedExpansion))
	}
	if m.PackagePath != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("packagePath"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.PackagePath))
	}
	if m.MtlsRootUrl != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("mtlsRootUrl"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.MtlsRootUrl))
	}
	return info
}

// ToRawInfo returns a description of Icons suitable for JSON or YAML export.
func (m *Icons) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	// always include this required field.
	info.Content = append(info.Content, compiler.NewScalarNodeForString("x16"))
	info.Content = append(info.Content, compiler.NewScalarNodeForString(m.X16))
	// always include this required field.
	info.Content = append(info.Content, compiler.NewScalarNodeForString("x32"))
	info.Content = append(info.Content, compiler.NewScalarNodeForString(m.X32))
	return info
}

// ToRawInfo returns a description of MediaUpload suitable for JSON or YAML export.
func (m *MediaUpload) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if len(m.Accept) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("accept"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.Accept))
	}
	if m.MaxSize != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("maxSize"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.MaxSize))
	}
	if m.Protocols != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("protocols"))
		info.Content = append(info.Content, m.Protocols.ToRawInfo())
	}
	if m.SupportsSubscription {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("supportsSubscription"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.SupportsSubscription))
	}
	return info
}

// ToRawInfo returns a description of Method suitable for JSON or YAML export.
func (m *Method) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Id != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("id"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Id))
	}
	if m.Path != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("path"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Path))
	}
	if m.HttpMethod != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("httpMethod"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.HttpMethod))
	}
	if m.Description != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("description"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Description))
	}
	if m.Parameters != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("parameters"))
		info.Content = append(info.Content, m.Parameters.ToRawInfo())
	}
	if len(m.ParameterOrder) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("parameterOrder"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.ParameterOrder))
	}
	if m.Request != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("request"))
		info.Content = append(info.Content, m.Request.ToRawInfo())
	}
	if m.Response != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("response"))
		info.Content = append(info.Content, m.Response.ToRawInfo())
	}
	if len(m.Scopes) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("scopes"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.Scopes))
	}
	if m.SupportsMediaDownload {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("supportsMediaDownload"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.SupportsMediaDownload))
	}
	if m.SupportsMediaUpload {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("supportsMediaUpload"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.SupportsMediaUpload))
	}
	if m.UseMediaDownloadService {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("useMediaDownloadService"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.UseMediaDownloadService))
	}
	if m.MediaUpload != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("mediaUpload"))
		info.Content = append(info.Content, m.MediaUpload.ToRawInfo())
	}
	if m.SupportsSubscription {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("supportsSubscription"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.SupportsSubscription))
	}
	if m.FlatPath != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("flatPath"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.FlatPath))
	}
	if m.EtagRequired {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("etagRequired"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.EtagRequired))
	}
	if m.StreamingType != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("streamingType"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.StreamingType))
	}
	return info
}

// ToRawInfo returns a description of Methods suitable for JSON or YAML export.
func (m *Methods) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info.Content = append(info.Content, compiler.NewScalarNodeForString(item.Name))
			info.Content = append(info.Content, item.Value.ToRawInfo())
		}
	}
	return info
}

// ToRawInfo returns a description of NamedMethod suitable for JSON or YAML export.
func (m *NamedMethod) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Name != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("name"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Name))
	}
	// &{Name:value Type:Method StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedParameter suitable for JSON or YAML export.
func (m *NamedParameter) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Name != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("name"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Name))
	}
	// &{Name:value Type:Parameter StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedResource suitable for JSON or YAML export.
func (m *NamedResource) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Name != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("name"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Name))
	}
	// &{Name:value Type:Resource StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedSchema suitable for JSON or YAML export.
func (m *NamedSchema) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Name != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("name"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Name))
	}
	// &{Name:value Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedScope suitable for JSON or YAML export.
func (m *NamedScope) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Name != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("name"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Name))
	}
	// &{Name:value Type:Scope StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of Oauth2 suitable for JSON or YAML export.
func (m *Oauth2) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Scopes != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("scopes"))
		info.Content = append(info.Content, m.Scopes.ToRawInfo())
	}
	return info
}

// ToRawInfo returns a description of Parameter suitable for JSON or YAML export.
func (m *Parameter) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Id != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("id"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Id))
	}
	if m.Type != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("type"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Type))
	}
	if m.XRef != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("$ref"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.XRef))
	}
	if m.Description != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("description"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Description))
	}
	if m.Default != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("default"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Default))
	}
	if m.Required {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("required"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.Required))
	}
	if m.Format != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("format"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Format))
	}
	if m.Pattern != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("pattern"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Pattern))
	}
	if m.Minimum != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("minimum"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Minimum))
	}
	if m.Maximum != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("maximum"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Maximum))
	}
	if len(m.Enum) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("enum"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.Enum))
	}
	if len(m.EnumDescriptions) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("enumDescriptions"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.EnumDescriptions))
	}
	if m.Repeated {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("repeated"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.Repeated))
	}
	if m.Location != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("location"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Location))
	}
	if m.Properties != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("properties"))
		info.Content = append(info.Content, m.Properties.ToRawInfo())
	}
	if m.AdditionalProperties != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("additionalProperties"))
		info.Content = append(info.Content, m.AdditionalProperties.ToRawInfo())
	}
	if m.Items != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("items"))
		info.Content = append(info.Content, m.Items.ToRawInfo())
	}
	if m.Annotations != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("annotations"))
		info.Content = append(info.Content, m.Annotations.ToRawInfo())
	}
	return info
}

// ToRawInfo returns a description of Parameters suitable for JSON or YAML export.
func (m *Parameters) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info.Content = append(info.Content, compiler.NewScalarNodeForString(item.Name))
			info.Content = append(info.Content, item.Value.ToRawInfo())
		}
	}
	return info
}

// ToRawInfo returns a description of Protocols suitable for JSON or YAML export.
func (m *Protocols) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Simple != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("simple"))
		info.Content = append(info.Content, m.Simple.ToRawInfo())
	}
	if m.Resumable != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("resumable"))
		info.Content = append(info.Content, m.Resumable.ToRawInfo())
	}
	return info
}

// ToRawInfo returns a description of Request suitable for JSON or YAML export.
func (m *Request) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.XRef != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("$ref"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.XRef))
	}
	if m.ParameterName != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("parameterName"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.ParameterName))
	}
	return info
}

// ToRawInfo returns a description of Resource suitable for JSON or YAML export.
func (m *Resource) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Methods != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("methods"))
		info.Content = append(info.Content, m.Methods.ToRawInfo())
	}
	if m.Resources != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("resources"))
		info.Content = append(info.Content, m.Resources.ToRawInfo())
	}
	return info
}

// ToRawInfo returns a description of Resources suitable for JSON or YAML export.
func (m *Resources) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info.Content = append(info.Content, compiler.NewScalarNodeForString(item.Name))
			info.Content = append(info.Content, item.Value.ToRawInfo())
		}
	}
	return info
}

// ToRawInfo returns a description of Response suitable for JSON or YAML export.
func (m *Response) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.XRef != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("$ref"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.XRef))
	}
	return info
}

// ToRawInfo returns a description of Resumable suitable for JSON or YAML export.
func (m *Resumable) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Multipart {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("multipart"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.Multipart))
	}
	if m.Path != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("path"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Path))
	}
	return info
}

// ToRawInfo returns a description of Schema suitable for JSON or YAML export.
func (m *Schema) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Id != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("id"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Id))
	}
	if m.Type != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("type"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Type))
	}
	if m.Description != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("description"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Description))
	}
	if m.Default != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("default"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Default))
	}
	if m.Required {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("required"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.Required))
	}
	if m.Format != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("format"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Format))
	}
	if m.Pattern != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("pattern"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Pattern))
	}
	if m.Minimum != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("minimum"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Minimum))
	}
	if m.Maximum != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("maximum"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Maximum))
	}
	if len(m.Enum) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("enum"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.Enum))
	}
	if len(m.EnumDescriptions) != 0 {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("enumDescriptions"))
		info.Content = append(info.Content, compiler.NewSequenceNodeForStringArray(m.EnumDescriptions))
	}
	if m.Repeated {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("repeated"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.Repeated))
	}
	if m.Location != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("location"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Location))
	}
	if m.Properties != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("properties"))
		info.Content = append(info.Content, m.Properties.ToRawInfo())
	}
	if m.AdditionalProperties != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("additionalProperties"))
		info.Content = append(info.Content, m.AdditionalProperties.ToRawInfo())
	}
	if m.Items != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("items"))
		info.Content = append(info.Content, m.Items.ToRawInfo())
	}
	if m.XRef != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("$ref"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.XRef))
	}
	if m.Annotations != nil {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("annotations"))
		info.Content = append(info.Content, m.Annotations.ToRawInfo())
	}
	if m.ReadOnly {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("readOnly"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.ReadOnly))
	}
	return info
}

// ToRawInfo returns a description of Schemas suitable for JSON or YAML export.
func (m *Schemas) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info.Content = append(info.Content, compiler.NewScalarNodeForString(item.Name))
			info.Content = append(info.Content, item.Value.ToRawInfo())
		}
	}
	return info
}

// ToRawInfo returns a description of Scope suitable for JSON or YAML export.
func (m *Scope) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Description != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("description"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Description))
	}
	return info
}

// ToRawInfo returns a description of Scopes suitable for JSON or YAML export.
func (m *Scopes) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info.Content = append(info.Content, compiler.NewScalarNodeForString(item.Name))
			info.Content = append(info.Content, item.Value.ToRawInfo())
		}
	}
	return info
}

// ToRawInfo returns a description of Simple suitable for JSON or YAML export.
func (m *Simple) ToRawInfo() *yaml.Node {
	info := compiler.NewMappingNode()
	if m == nil {
		return info
	}
	if m.Multipart {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("multipart"))
		info.Content = append(info.Content, compiler.NewScalarNodeForBool(m.Multipart))
	}
	if m.Path != "" {
		info.Content = append(info.Content, compiler.NewScalarNodeForString("path"))
		info.Content = append(info.Content, compiler.NewScalarNodeForString(m.Path))
	}
	return info
}

// ToRawInfo returns a description of StringArray suitable for JSON or YAML export.
func (m *StringArray) ToRawInfo() *yaml.Node {
	return compiler.NewSequenceNodeForStringArray(m.Value)
}
