/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sg extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "Zâmani";
        final String metaValue_FR = "Farânzi";
        final String metaValue_IN = "Ênnde";
        final String metaValue_RW = "Ruandäa";
        final String metaValue_SO = "Somalïi";
        final String metaValue_UA = "Ukrêni";
        final String metaValue_VN = "Vietnäm";
        final Object[][] data = new Object[][] {
            { "AD", "Andôro" },
            { "AE", "Arâbo Emirâti Ôko" },
            { "AF", "Faganïta, Afganïstäan" },
            { "AG", "Antîgua na Barbûda" },
            { "AI", "Angûîla" },
            { "AL", "Albanïi" },
            { "AM", "Armenïi" },
            { "AO", "Angoläa" },
            { "AR", "Arzantîna" },
            { "AS", "Samöa tî Amerîka" },
            { "AT", "Otrîsi" },
            { "AU", "Ostralïi, Sotralïi" },
            { "AW", "Arûba" },
            { "AZ", "Zerebaidyäan, Azerbaidyäan," },
            { "BA", "Bosnïi na Herzegovînni" },
            { "BB", "Barabâda" },
            { "BD", "Bengladêshi" },
            { "BE", "Bêleze, Belezîki" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulugarïi" },
            { "BH", "Bahrâina" },
            { "BI", "Burundïi" },
            { "BJ", "Benëen" },
            { "BM", "Beremûda" },
            { "BN", "Brunêi" },
            { "BO", "Bolivïi" },
            { "BR", "Brezîli" },
            { "BS", "Bahâmasa" },
            { "BT", "Butäan" },
            { "BW", "Botswana" },
            { "BY", "Belarüsi" },
            { "BZ", "Belîzi" },
            { "CA", "Kanadäa" },
            { "CD", "Ködörösêse tî Ngunuhalëzo tî kongö" },
            { "CF", "Ködörösêse tî Bêafrîka" },
            { "CG", "Kongö" },
            { "CH", "Sûîsi" },
            { "CI", "Kôdivüära" },
            { "CK", "âzûâ Kûku" },
            { "CL", "Shilïi" },
            { "CM", "Kamerûne" },
            { "CN", "Shîna" },
            { "CO", "Kolombïi" },
            { "CR", "Kôsta Rîka" },
            { "CU", "Kubäa" },
            { "CV", "Azûâ tî Kâpo-Vêre" },
            { "CY", "Sîpri" },
            { "CZ", "Ködörösêse tî Tyêki" },
            { "DE", metaValue_DE },
            { "DJ", "Dibutùii" },
            { "DK", "Danemêrke" },
            { "DM", "Dömïnîka" },
            { "DO", "Ködörösêse tî Dominîka" },
            { "DZ", "Alzerïi" },
            { "EC", "Ekuatëre" },
            { "EE", "Estonïi" },
            { "EG", "Kâmitâ" },
            { "ER", "Eritrëe" },
            { "ES", "Espânye" },
            { "ET", "Etiopïi" },
            { "FI", "Fëlânde" },
            { "FJ", "Fidyïi" },
            { "FK", "Âzûâ tî Mälüîni" },
            { "FM", "Mikronezïi" },
            { "FR", metaValue_FR },
            { "GA", "Gaböon" },
            { "GB", "Ködörögbïä--Ôko" },
            { "GD", "Grenâda" },
            { "GE", "Zorzïi" },
            { "GF", "Güyâni tî farânzi" },
            { "GH", "Ganäa" },
            { "GI", "Zibraltära, Zibaratära" },
            { "GL", "Gorolânde" },
            { "GM", "Gambïi" },
            { "GN", "Ginëe" },
            { "GP", "Guadelûpu" },
            { "GQ", "Ginëe tî Ekuatëre" },
            { "GR", "Gerêsi" },
            { "GT", "Guatêmälä" },
            { "GU", "Guâm" },
            { "GW", "Gninëe-Bisau" },
            { "GY", "Gayâna" },
            { "HN", "Honduräsi" },
            { "HR", "Kroasïi" },
            { "HT", "Haitïi" },
            { "HU", "Hongirùii" },
            { "ID", "Ênndonezïi" },
            { "IE", "Irlânde" },
            { "IL", "Israëli" },
            { "IN", metaValue_IN },
            { "IQ", "Irâki" },
            { "IR", "Iräan" },
            { "IS", "Islânde" },
            { "IT", "Italùii" },
            { "JM", "Zamaîka" },
            { "JO", "Zordanïi" },
            { "JP", "Zapöon" },
            { "KE", "Kenyäa" },
            { "KG", "Kirigizitùaan" },
            { "KH", "Kämbôzi" },
            { "KI", "Kiribati" },
            { "KM", "Kömôro" },
            { "KN", "Sên-Krïstôfo-na-Nevîsi" },
            { "KP", "Korëe tî Banga" },
            { "KR", "Korëe tî Mbongo" },
            { "KW", "Köwêti" },
            { "KY", "Âzûâ Ngundë, Kaimäni" },
            { "KZ", "Kazakisitäan" },
            { "LA", "Lùaôsi" },
            { "LB", "Libùaan" },
            { "LC", "Sênt-Lisïi" },
            { "LI", "Liechtenstein," },
            { "LK", "Sirî-Lanka" },
            { "LR", "Liberïa" },
            { "LS", "Lesôtho" },
            { "LT", "Lituanïi" },
            { "LU", "Lugzambûru" },
            { "LV", "Letonùii" },
            { "LY", "Libïi" },
            { "MA", "Marôko" },
            { "MC", "Monaköo" },
            { "MD", "Moldavùii" },
            { "MG", "Madagaskära" },
            { "MH", "Âzûâ Märshâl" },
            { "ML", "Malïi" },
            { "MM", "Myämâra" },
            { "MN", "Mongolïi" },
            { "MP", "Âzûâ Märïâni tî Banga" },
            { "MQ", "Märtïnîki" },
            { "MR", "Moritanïi" },
            { "MS", "Monserâte" },
            { "MT", "Mâlta" },
            { "MU", "Mörîsi" },
            { "MV", "Maldîva" },
            { "MW", "Malawïi" },
            { "MX", "Mekisîki" },
            { "MY", "Malezïi" },
            { "MZ", "Mözämbîka" },
            { "NA", "Namibùii" },
            { "NC", "Finî Kaledonïi" },
            { "NE", "Nizëre" },
            { "NF", "Zûâ Nôrfôlko" },
            { "NG", "Nizerïa" },
            { "NI", "Nikaragua" },
            { "NL", "Holände" },
            { "NO", "Nörvêzi" },
            { "NP", "Nëpâli" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Finî Zelânde" },
            { "OM", "Omâni" },
            { "PA", "Panama" },
            { "PE", "Perüu" },
            { "PF", "Polinezïi tî farânzi" },
            { "PG", "Papû Finî Ginëe, Papuazïi" },
            { "PH", "Filipîni" },
            { "PK", "Pakistäan" },
            { "PL", "Pölôni" },
            { "PM", "Sên-Pyêre na Mikelöon" },
            { "PN", "Pitikêrni" },
            { "PR", "Porto Rîko" },
            { "PS", "Sêse tî Palestîni" },
            { "PT", "Pörtugäle, Ködörö Pûra" },
            { "PW", "Palau" },
            { "PY", "Paraguëe" },
            { "QA", "Katära" },
            { "RE", "Reinïon" },
            { "RO", "Rumanïi" },
            { "RU", "Rusïi" },
            { "RW", metaValue_RW },
            { "SA", "Saûdi Arabïi" },
            { "SB", "Zûâ Salomöon" },
            { "SC", "Sëyshêle" },
            { "SD", "Sudäan" },
            { "SE", "Suêde" },
            { "SG", "Sïngäpûru" },
            { "SH", "Sênt-Helêna" },
            { "SI", "Solovenïi" },
            { "SK", "Solovakïi" },
            { "SL", "Sierä-Leône" },
            { "SM", "Sên-Marëen" },
            { "SN", "Senegäle" },
            { "SO", metaValue_SO },
            { "SR", "Surinäm" },
            { "ST", "Sâô Tömê na Prinsîpe" },
            { "SV", "Salvadöro" },
            { "SY", "Sirïi" },
            { "SZ", "Swäzïlânde" },
            { "TC", "Âzûâ Turku na Kaîki" },
            { "TD", "Tyâde" },
            { "TG", "Togö" },
            { "TH", "Tailânde" },
            { "TJ", "Taazikiistäan" },
            { "TK", "Tokelau" },
            { "TL", "Timôro tî Tö" },
            { "TM", "Turkumenistäan" },
            { "TN", "Tunizïi" },
            { "TO", "Tonga" },
            { "TR", "Turukïi" },
            { "TT", "Trinitùee na Tobagö" },
            { "TV", "Tüvalü" },
            { "TW", "Tâiwâni" },
            { "TZ", "Tanzanïi" },
            { "UA", metaValue_UA },
            { "UG", "Ugandäa" },
            { "US", "ÂLeaa-Ôko tî Amerika" },
            { "UY", "Uruguëe" },
            { "UZ", "Uzbekistäan" },
            { "VA", "Letëe tî Vatikäan" },
            { "VC", "Sên-Vensäan na âGrenadîni" },
            { "VE", "Venezueläa" },
            { "VG", "Âzôâ Viîrîggo tî Anglëe" },
            { "VI", "Âzûâ Virîgo tî Amerîka" },
            { "VN", metaValue_VN },
            { "VU", "Vanuatü" },
            { "WF", "Walîsi na Futuna" },
            { "WS", "Samoäa" },
            { "YE", "Yëmêni" },
            { "YT", "Mäyôte" },
            { "ZA", "Mbongo-Afrîka" },
            { "ZM", "Zambïi" },
            { "ZW", "Zimbäbwe" },
            { "ak", "Akâan" },
            { "am", "Amarîki" },
            { "ar", "Arâbo" },
            { "be", "Bielörûsi" },
            { "bg", "Bulugäri" },
            { "bn", "Bengäli" },
            { "cs", "Tyêki" },
            { "de", metaValue_DE },
            { "el", "Gerêki" },
            { "en", "Anglëe" },
            { "es", "Espanyöl" },
            { "fa", "Farsî" },
            { "fr", metaValue_FR },
            { "ha", "Haüsä" },
            { "hi", "Hîndi" },
            { "hu", "Hongruäa" },
            { "id", "Enndonezïi" },
            { "ig", "Ïgbö" },
            { "it", metaValue_IN },
            { "ja", "Zaponëe" },
            { "jv", "Zavanëe" },
            { "km", "Kmêre" },
            { "ko", "Koreyëen" },
            { "ms", "Malëe" },
            { "my", "Miamära, Birimäni" },
            { "ne", "Nepalëe" },
            { "nl", "Holandëe" },
            { "pa", "Penzäbï" },
            { "pl", "Polonëe" },
            { "pt", "Portugëe, Pûra" },
            { "ro", "Rumëen" },
            { "ru", "Rûsi" },
            { "rw", metaValue_RW },
            { "sg", "Sängö" },
            { "so", metaValue_SO },
            { "sv", "Sueduäa" },
            { "ta", "Tämûli" },
            { "th", "Thâi" },
            { "tr", "Tûrûku" },
            { "uk", metaValue_UA },
            { "ur", "Ûrdu" },
            { "vi", metaValue_VN },
            { "yo", "Yoruba" },
            { "zh", "Shinuäa" },
            { "zu", "Zûlu" },
        };
        return data;
    }
}
