/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "Għarbi";
        final String metaValue_el = "Grieg";
        final String metaValue_ja = "Ġappuniż";
        final String metaValue_la = "Latin";
        final String metaValue_peo = "Persjan Antik";
        final String metaValue_Hant = "Tradizzjonali";
        final Object[][] data = new Object[][] {
            { "001", "Dinja" },
            { "002", "Affrika" },
            { "005", "Amerika t’Isfel" },
            { "009", "Oċejanja" },
            { "011", "Affrika tal-Punent" },
            { "013", "Amerika Ċentrali" },
            { "014", "Affrika tal-Lvant" },
            { "015", "Affrika ta’ Fuq" },
            { "017", "Affrika Nofsani" },
            { "018", "Affrika t’Isfel" },
            { "019", "Amerika" },
            { "029", "Karibew" },
            { "030", "Asja tal-Lvant" },
            { "034", "Asja t’Isfel Ċentrali" },
            { "035", "Asja tax-Xlokk" },
            { "039", "Ewropa t’Isfel" },
            { "053", "Awstralja u New Zealand" },
            { "054", "Melanesja" },
            { "057", "Reġjun ta’ Mikroneżja" },
            { "061", "Polinesja" },
            { "142", "Asja" },
            { "143", "Asja Ċentrali" },
            { "145", "Asja tal-Punent" },
            { "150", "Ewropa" },
            { "151", "Ewropa tal-Lvant" },
            { "154", "Ewropa ta’ Fuq" },
            { "155", "Ewropa tal-Punent" },
            { "419", "Amerika Latina" },
            { "AC", "Ascension Island" },
            { "AD", "Andorra" },
            { "AE", "l-Emirati Għarab Magħquda" },
            { "AF", "l-Afganistan" },
            { "AG", "Antigua u Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "l-Albanija" },
            { "AM", "l-Armenja" },
            { "AO", "l-Angola" },
            { "AQ", "l-Antartika" },
            { "AR", "l-Arġentina" },
            { "AS", "is-Samoa Amerikana" },
            { "AT", "l-Awstrija" },
            { "AU", "l-Awstralja" },
            { "AW", "Aruba" },
            { "AX", "il-Gżejjer Aland" },
            { "AZ", "l-Ażerbajġan" },
            { "BA", "il-Bożnija-Ħerzegovina" },
            { "BB", "Barbados" },
            { "BD", "il-Bangladesh" },
            { "BE", "il-Belġju" },
            { "BF", "il-Burkina Faso" },
            { "BG", "il-Bulgarija" },
            { "BH", "il-Bahrain" },
            { "BI", "il-Burundi" },
            { "BJ", "il-Benin" },
            { "BL", "Saint Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "il-Brunei" },
            { "BO", "il-Bolivja" },
            { "BQ", "in-Netherlands tal-Karibew" },
            { "BR", "Il-Brażil" },
            { "BS", "il-Bahamas" },
            { "BT", "il-Bhutan" },
            { "BV", "Gżira Bouvet" },
            { "BW", "il-Botswana" },
            { "BY", "il-Belarussja" },
            { "BZ", "il-Belize" },
            { "CA", "il-Kanada" },
            { "CC", "Gżejjer Cocos (Keeling)" },
            { "CD", "ir-Repubblika Demokratika tal-Kongo" },
            { "CF", "ir-Repubblika Ċentru-Afrikana" },
            { "CG", "il-Kongo - Brazzaville" },
            { "CH", "l-Iżvizzera" },
            { "CI", "il-Kosta tal-Avorju" },
            { "CK", "Gżejjer Cook" },
            { "CL", "iċ-Ċili" },
            { "CM", "il-Kamerun" },
            { "CN", "iċ-Ċina" },
            { "CO", "il-Kolombja" },
            { "CP", "il-Gżira Clipperton" },
            { "CR", "il-Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Cape Verde" },
            { "CW", "Curaçao" },
            { "CX", "il-Gżira Christmas" },
            { "CY", "Ċipru" },
            { "CZ", "ir-Repubblika Ċeka" },
            { "DE", "il-Ġermanja" },
            { "DG", "Diego Garcia" },
            { "DJ", "il-Djibouti" },
            { "DK", "id-Danimarka" },
            { "DM", "Dominica" },
            { "DO", "ir-Repubblika Dominicana" },
            { "DZ", "l-Alġerija" },
            { "EA", "Ceuta u Melilla" },
            { "EC", "l-Ekwador" },
            { "EE", "l-Estonja" },
            { "EG", "l-Eġittu" },
            { "EH", "is-Saħara tal-Punent" },
            { "ER", "l-Eritrea" },
            { "ES", "Spanja" },
            { "ET", "l-Etjopja" },
            { "EU", "Unjoni Ewropea" },
            { "FI", "il-Finlandja" },
            { "FJ", "Fiġi" },
            { "FK", "il-Gżejjer Falkland" },
            { "FM", "il-Mikroneżja" },
            { "FO", "il-Gżejjer Faeroe" },
            { "FR", "Franza" },
            { "GA", "il-Gabon" },
            { "GB", "ir-Renju Unit" },
            { "GD", "Grenada" },
            { "GE", "il-Georgia" },
            { "GF", "il-Guyana Franċiża" },
            { "GG", "Guernsey" },
            { "GH", "il-Ghana" },
            { "GI", "Ġibiltà" },
            { "GL", "Greenland" },
            { "GM", "il-Gambja" },
            { "GN", "il-Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "il-Guinea Ekwatorjali" },
            { "GR", "il-Greċja" },
            { "GS", "il-Georgia tan-Nofsinhar u l-Gżejjer Sandwich tan-Nofsinhar" },
            { "GT", "il-Gwatemala" },
            { "GU", "Guam" },
            { "GW", "il-Guinea-Bissau" },
            { "GY", "il-Guyana" },
            { "HK", "ir-Reġjun Amministrattiv Speċjali ta’ Hong Kong tar-Repubblika tal-Poplu taċ-Ċina" },
            { "HM", "il-Gżejjer Heard u l-Gżejjer McDonald" },
            { "HN", "il-Honduras" },
            { "HR", "il-Kroazja" },
            { "HT", "il-Haiti" },
            { "HU", "l-Ungerija" },
            { "IC", "il-Gżejjer Canary" },
            { "ID", "l-Indoneżja" },
            { "IE", "l-Irlanda" },
            { "IL", "Iżrael" },
            { "IM", "Isle of Man" },
            { "IN", "l-Indja" },
            { "IQ", "l-Iraq" },
            { "IR", "l-Iran" },
            { "IS", "l-Iżlanda" },
            { "IT", "l-Italja" },
            { "JE", "Jersey" },
            { "JM", "il-Ġamajka" },
            { "JO", "il-Ġordan" },
            { "JP", "il-Ġappun" },
            { "KE", "il-Kenja" },
            { "KG", "il-Kirgiżistan" },
            { "KH", "il-Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "Saint Kitts u Nevis" },
            { "KP", "il-Korea ta’ Fuq" },
            { "KR", "il-Korea t’Isfel" },
            { "KW", "il-Kuwajt" },
            { "KY", "il-Gżejjer Cayman" },
            { "KZ", "il-Każakistan" },
            { "LA", "il-Laos" },
            { "LB", "il-Libanu" },
            { "LC", "Saint Lucia" },
            { "LI", "il-Liechtenstein" },
            { "LK", "is-Sri Lanka" },
            { "LR", "il-Liberja" },
            { "LS", "il-Lesoto" },
            { "LT", "il-Litwanja" },
            { "LU", "il-Lussemburgu" },
            { "LV", "il-Latvja" },
            { "LY", "il-Libja" },
            { "MA", "il-Marokk" },
            { "MC", "Monaco" },
            { "MD", "il-Moldova" },
            { "ME", "il-Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Gżejjer Marshall" },
            { "MK", "il-Maċedonja ta’ Fuq" },
            { "ML", "il-Mali" },
            { "MM", "il-Myanmar/Burma" },
            { "MN", "il-Mongolja" },
            { "MO", "ir-Reġjun Amministrattiv Speċjali tal-Macao tar-Repubblika tal-Poplu taċ-Ċina" },
            { "MP", "Ġżejjer Mariana tat-Tramuntana" },
            { "MQ", "Martinique" },
            { "MR", "il-Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "il-Maldivi" },
            { "MW", "il-Malawi" },
            { "MX", "il-Messiku" },
            { "MY", "il-Malasja" },
            { "MZ", "il-Mozambique" },
            { "NA", "in-Namibja" },
            { "NC", "New Caledonia" },
            { "NE", "in-Niġer" },
            { "NF", "Gżira Norfolk" },
            { "NG", "in-Niġerja" },
            { "NI", "in-Nikaragwa" },
            { "NL", "in-Netherlands" },
            { "NO", "in-Norveġja" },
            { "NP", "in-Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "l-Oman" },
            { "PA", "il-Panama" },
            { "PE", "il-Perù" },
            { "PF", "Polineżja Franċiża" },
            { "PG", "Papua New Guinea" },
            { "PH", "il-Filippini" },
            { "PK", "il-Pakistan" },
            { "PL", "il-Polonja" },
            { "PM", "Saint Pierre u Miquelon" },
            { "PN", "Gżejjer Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "it-Territorji Palestinjani" },
            { "PT", "il-Portugall" },
            { "PW", "Palau" },
            { "PY", "il-Paragwaj" },
            { "QA", "il-Qatar" },
            { "RE", "Réunion" },
            { "RO", "ir-Rumanija" },
            { "RS", "is-Serbja" },
            { "RU", "ir-Russja" },
            { "RW", "ir-Rwanda" },
            { "SA", "l-Arabja Sawdija" },
            { "SB", "il-Gżejjer Solomon" },
            { "SC", "is-Seychelles" },
            { "SD", "is-Sudan" },
            { "SE", "l-Iżvezja" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "SI", "is-Slovenja" },
            { "SJ", "Svalbard u Jan Mayen" },
            { "SK", "is-Slovakkja" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "is-Senegal" },
            { "SO", "is-Somalja" },
            { "SR", "is-Suriname" },
            { "SS", "is-Sudan t’Isfel" },
            { "ST", "São Tomé u Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "is-Sirja" },
            { "SZ", "l-Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "il-Gżejjer Turks u Caicos" },
            { "TD", "iċ-Chad" },
            { "TF", "It-Territorji Franċiżi tan-Nofsinhar" },
            { "TG", "it-Togo" },
            { "TH", "it-Tajlandja" },
            { "TJ", "it-Taġikistan" },
            { "TK", "it-Tokelau" },
            { "TL", "Timor Leste" },
            { "TM", "it-Turkmenistan" },
            { "TN", "it-Tuneżija" },
            { "TO", "Tonga" },
            { "TR", "it-Turkija" },
            { "TT", "Trinidad u Tobago" },
            { "TV", metaValue_TV },
            { "TW", "it-Tajwan" },
            { "TZ", "it-Tanzanija" },
            { "UA", "l-Ukrajna" },
            { "UG", "l-Uganda" },
            { "UM", "Il-Gżejjer Minuri Mbiegħda tal-Istati Uniti" },
            { "US", "l-Istati Uniti" },
            { "UY", "l-Urugwaj" },
            { "UZ", "l-Użbekistan" },
            { "VA", "l-Istat tal-Belt tal-Vatikan" },
            { "VC", "Saint Vincent u l-Grenadini" },
            { "VE", "il-Venezwela" },
            { "VG", "il-Gżejjer Verġni Brittaniċi" },
            { "VI", "il-Gżejjer Verġni tal-Istati Uniti" },
            { "VN", "il-Vjetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis u Futuna" },
            { "WS", "Samoa" },
            { "XK", "il-Kosovo" },
            { "YE", "il-Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "l-Afrika t’Isfel" },
            { "ZM", "iż-Żambja" },
            { "ZW", "iż-Żimbabwe" },
            { "ZZ", "Reġjun Mhux Magħruf" },
            { "aa", "Afar" },
            { "ab", "Abkażjan" },
            { "ae", "Avestan" },
            { "af", "Afrikans" },
            { "ak", "Akan" },
            { "am", "Amhariku" },
            { "an", "Aragoniż" },
            { "ar", metaValue_ar },
            { "as", "Assamiż" },
            { "av", "Avarik" },
            { "ay", "Aymara" },
            { "az", "Ażerbajġani" },
            { "ba", "Bashkir" },
            { "be", "Belarussu" },
            { "bg", "Bulgaru" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengali" },
            { "bo", "Tibetjan" },
            { "br", "Breton" },
            { "bs", "Bożnijaku" },
            { "ca", "Katalan" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Korsiku" },
            { "cr", "Cree" },
            { "cs", "Ċek" },
            { "cu", "Slaviku tal-Knisja" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Daniż" },
            { "de", "Ġermaniż" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Ingliż" },
            { "eo", "Esperanto" },
            { "es", "Spanjol" },
            { "et", "Estonjan" },
            { "eu", "Bask" },
            { "fa", "Persjan" },
            { "ff", "Fulah" },
            { "fi", "Finlandiż" },
            { "fj", "Fiġjan" },
            { "fo", "Faroese" },
            { "fr", "Franċiż" },
            { "fy", "Frisian tal-Punent" },
            { "ga", "Irlandiż" },
            { "gd", "Galliku Skoċċiż" },
            { "gl", "Galiċjan" },
            { "gn", "Guarani" },
            { "gu", "Gujarati" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", "Ebrajk" },
            { "hi", "Hindi" },
            { "ho", "Hiri Motu" },
            { "hr", "Kroat" },
            { "ht", "Creole ta’ Haiti" },
            { "hu", "Ungeriż" },
            { "hy", "Armen" },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indoneżjan" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "ik", "Inupjak" },
            { "io", "Ido" },
            { "is", "Iżlandiż" },
            { "it", "Taljan" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "Ġavaniż" },
            { "ka", "Ġorġjan" },
            { "kg", "Kongo" },
            { "ki", "Kikuju" },
            { "kj", "Kuanyama" },
            { "kk", "Każak" },
            { "kl", "Kalallisut" },
            { "km", "Khmer" },
            { "kn", "Kannada" },
            { "ko", "Korean" },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurd" },
            { "kv", "Komi" },
            { "kw", "Korniku" },
            { "ky", "Kirgiż" },
            { "la", metaValue_la },
            { "lb", "Lussemburgiż" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingaljan" },
            { "lo", "Laosjan" },
            { "lt", "Litwan" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvjan" },
            { "mg", "Malagasy" },
            { "mh", "Marshalljaniż" },
            { "mi", "Maori" },
            { "mk", "Maċedonjan" },
            { "ml", "Malayalam" },
            { "mn", "Mongoljan" },
            { "mr", "Marathi" },
            { "ms", "Malay" },
            { "mt", "Malti" },
            { "my", "Burmiż" },
            { "na", "Naurujan" },
            { "nb", "Bokmal Norveġiż" },
            { "nd", "Ndebeli tat-Tramuntana" },
            { "ne", "Nepaliż" },
            { "ng", "Ndonga" },
            { "nl", "Olandiż" },
            { "nn", "Ninorsk Norveġiż" },
            { "no", "Norveġiż" },
            { "nr", "Ndebele tan-Nofsinhar" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Oċċitan" },
            { "oj", "Oġibwa" },
            { "om", "Oromo" },
            { "or", "Odia" },
            { "os", "Ossettiku" },
            { "pa", "Punjabi" },
            { "pi", "Pali" },
            { "pl", "Pollakk" },
            { "ps", "Pashto" },
            { "pt", "Portugiż" },
            { "qu", "Quechua" },
            { "rm", "Romanz" },
            { "rn", "Rundi" },
            { "ro", "Rumen" },
            { "ru", "Russu" },
            { "rw", "Kinjarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinjan" },
            { "sd", "Sindhi" },
            { "se", "Sami tat-Tramuntana" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroat" },
            { "si", "Sinhala" },
            { "sk", "Slovakk" },
            { "sl", "Sloven" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albaniż" },
            { "sr", "Serb" },
            { "ss", "Swati" },
            { "st", "Soto tan-Nofsinhar" },
            { "su", "Sundaniż" },
            { "sv", "Żvediż" },
            { "sw", "Swahili" },
            { "ta", "Tamil" },
            { "te", "Telugu" },
            { "tg", "Taġik" },
            { "th", "Tajlandiż" },
            { "ti", "Tigrinya" },
            { "tk", "Turkmeni" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "tr", "Tork" },
            { "ts", "Tsonga" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Taħitjan" },
            { "ug", "Uyghur" },
            { "uk", "Ukren" },
            { "ur", "Urdu" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", "Vjetnamiż" },
            { "vo", "Volapuk" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Ċiniż" },
            { "zu", "Zulu" },
            { "ace", "Aċiniż" },
            { "ach", "Akoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "afh", "Afriħili" },
            { "agq", "Aghem" },
            { "ain", "Ajnu" },
            { "akk", "Akkadjen" },
            { "ale", "Aleut" },
            { "alt", "Altai tan-Nofsinhar" },
            { "ang", "Ingliż Antik" },
            { "anp", "Angika" },
            { "arc", "Aramajk" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "arw", "Arawak" },
            { "asa", "Asu" },
            { "ast", "Asturian" },
            { "awa", "Awadhi" },
            { "bal", "Baluċi" },
            { "ban", "Baliniż" },
            { "bas", "Basa" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bla", "Siksika" },
            { "bra", "Braj" },
            { "brx", "Bodo" },
            { "bua", "Burjat" },
            { "bug", "Buginese" },
            { "byn", "Blin" },
            { "cad", "Kaddo" },
            { "car", "Karib" },
            { "cch", "Atsam" },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "Ċukiż" },
            { "chm", "Mari" },
            { "chn", "Chinook Jargon" },
            { "cho", "Choctaw" },
            { "chp", "Ċipewjan" },
            { "chr", "Cherokee" },
            { "chy", "Cheyenne" },
            { "ckb", "Kurd Ċentrali" },
            { "cop", "Koptiku" },
            { "crh", "Tork tal-Krimea" },
            { "crs", "Franċiż tas-Seselwa Creole" },
            { "csb", "Kashubian" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "del", "Delawerjan" },
            { "den", "Slav" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Sorbjan Komuni" },
            { "dua", "Dwala" },
            { "dum", "Olandiż Medjevali" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egy", "Eġizzjan (Antik)" },
            { "eka", "Ekajuk" },
            { "elx", "Elamit" },
            { "enm", "Ingliż Medjevali" },
            { "ewo", "Ewondo" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filippin" },
            { "fon", "Fon" },
            { "frm", "Franċiż Medjevali" },
            { "fro", "Franċiż Antik" },
            { "fur", "Frijuljan" },
            { "gaa", "Ga" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gez", "Geez" },
            { "gil", "Gilbertjan" },
            { "gmh", "Ġermaniż Medjevali Pulit" },
            { "goh", "Ġermaniż Antik, Pulit" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", "Gotiku" },
            { "grb", "Grebo" },
            { "grc", "Grieg, Antik" },
            { "gsw", "Ġermaniż tal-Iżvizzera" },
            { "guz", "Gusii" },
            { "gwi", "Gwiċin" },
            { "hai", "Haida" },
            { "haw", "Ħawajjan" },
            { "hil", "Hiligaynon" },
            { "hit", "Hittite" },
            { "hmn", "Hmong" },
            { "hsb", "Sorbjan ta’ Fuq" },
            { "hup", "Hupa" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Lhudi-Persjan" },
            { "jrb", "Lhudi-Għarbi" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabuljan" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardian" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Cape Verdjan" },
            { "kfo", "Koro" },
            { "kha", "Khasi" },
            { "kho", "Kotaniż" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkani" },
            { "kos", "Kosrejan" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Kareljan" },
            { "kru", "Kurux" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Kolonjan" },
            { "kum", "Kumyk" },
            { "kut", "Kutenaj" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Leżgjan" },
            { "lkt", "Lakota" },
            { "lol", "Mongo" },
            { "loz", "Lożi" },
            { "lrc", "Luri tat-Tramuntana" },
            { "lua", "Luba-Luluwa" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "mad", "Maduriż" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "man", "Mandingo" },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "mdr", "Mandar" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Irlandiż Medjevali" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Metà" },
            { "mic", "Micmac" },
            { "min", "Minangkabau" },
            { "mnc", "Manchu" },
            { "mni", "Manipuri" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Lingwi Diversi" },
            { "mus", "Kriek" },
            { "mwl", "Mirandiż" },
            { "mwr", "Marwari" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nap", "Naplitan" },
            { "naq", "Nama" },
            { "nds", "Ġermaniż Komuni" },
            { "new", "Newari" },
            { "nia", "Nijas" },
            { "niu", "Niuean" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Nors Antik" },
            { "nqo", "N’Ko" },
            { "nso", "Soto tat-Tramuntana" },
            { "nus", "Nuer" },
            { "nwc", "Newari Klassiku" },
            { "nym", "Njamweżi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "osa", "Osaġjan" },
            { "ota", "Tork Ottoman" },
            { "pag", "Pangasinjan" },
            { "pal", "Pahlavi" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palawjan" },
            { "pcm", "Pidgin Niġerjan" },
            { "peo", metaValue_peo },
            { "phn", "Feniċju" },
            { "pon", "Ponpejan" },
            { "prg", "Prussu" },
            { "pro", "Provenzal Antik" },
            { "quc", "K’iche’" },
            { "raj", "Raġastani" },
            { "rap", "Rapanwi" },
            { "rar", "Rarotongani" },
            { "rof", "Rombo" },
            { "rom", "Romanesk" },
            { "rup", "Aromanjan" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "sam", "Samaritan Aramajk" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sqalli" },
            { "sco", "Skoċċiż" },
            { "seh", "Sena" },
            { "sel", "Selkup" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Irlandiż Antik" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "sid", "Sidamo" },
            { "sma", "Sami tan-Nofsinhar" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "sog", "Sogdien" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serer" },
            { "ssy", "Saho" },
            { "suk", "Sukuma" },
            { "sus", "Susu" },
            { "sux", "Sumerjan" },
            { "swb", "Komorjan" },
            { "syr", "Sirjan" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetum" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", "Tokelau" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "tsi", "Tsimshian" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinjan" },
            { "tzm", "Tamazight tal-Atlas Ċentrali" },
            { "udm", "Udmurt" },
            { "uga", "Ugaritiku" },
            { "umb", "Umbundu" },
            { "und", "Lingwa Mhix Magħrufa" },
            { "vai", "Vai" },
            { "vot", "Votik" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Walamo" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "xal", "Kalmyk" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yapese" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yue", "Kantoniż" },
            { "zap", "Zapotec" },
            { "zen", "Zenaga" },
            { "zgh", "Tamazight Standard tal-Marokk" },
            { "zun", "Zuni" },
            { "zxx", "Bla kontenut lingwistiku" },
            { "zza", "Zaza" },
            { "Arab", metaValue_ar },
            { "Brai", "Braille" },
            { "Cyrl", "Ċirilliku" },
            { "Grek", metaValue_el },
            { "Hans", "Simplifikat" },
            { "Hant", metaValue_Hant },
            { "Jpan", metaValue_ja },
            { "Latn", metaValue_la },
            { "Xpeo", metaValue_peo },
            { "Zxxx", "Mhux Miktub" },
            { "Zyyy", "Komuni" },
            { "Zzzz", "Kitba Mhux Magħrufa" },
            { "de_AT", "Ġermaniż Awstrijak" },
            { "de_CH", "Ġermaniż Żvizzeru" },
            { "en_AU", "Ingliż Awstraljan" },
            { "en_CA", "Ingliż Kanadiż" },
            { "en_GB", "Ingliż Brittaniku" },
            { "en_US", "Ingliż Amerikan" },
            { "es_ES", "Spanjol Ewropew" },
            { "es_MX", "Spanjol tal-Messiku" },
            { "fr_CA", "Franċiż Kanadiż" },
            { "fr_CH", "Franċiż Żvizzeru" },
            { "nl_BE", "Fjamming" },
            { "pt_BR", "Portugiż tal-Brażil" },
            { "pt_PT", "Portugiż Ewropew" },
            { "ro_MD", "Moldovan" },
            { "sw_CD", "Swahili tar-Repubblika Demokratika tal-Kongo" },
            { "ar_001", "Għarbi Standard Modern" },
            { "es_419", "Spanjol Latin Amerikan" },
            { "key.ca", "Kalendarju" },
            { "key.co", "Kollazjoni" },
            { "key.cu", "Munita" },
            { "nds_NL", "Sassonu Komuni" },
            { "zh_Hans", "Ċiniż Simplifikat" },
            { "zh_Hant", "Ċiniż Tradizzjonali" },
            { "%%REVISED", "Ortografija Irriveda" },
            { "type.nu.latn", "Numri tal-Punent" },
            { "type.ca.dangi", "Kalendarju Dangi" },
            { "type.ca.hebrew", "Kalendarju Ebrajk" },
            { "type.co.pinyin", "Ordni tal-Pinjin" },
            { "type.co.stroke", "Ordni Maħżuża" },
            { "type.ca.chinese", "Kalendarju Ċiniż" },
            { "type.ca.iso8601", "Kalendarju ISO-8601" },
            { "type.ca.buddhist", "Kalendarju Buddist" },
            { "type.ca.ethiopic", "Kalendarju Etjopiku" },
            { "type.ca.japanese", "Kalendarju Ġappuniż" },
            { "type.co.standard", "Ordni Standard" },
            { "type.ca.gregorian", "Kalendarju Gregorjan" },
            { "type.co.phonebook", "Ordni Telefonika" },
            { "type.co.traditional", metaValue_Hant },
        };
        return data;
    }
}
