<!--- This file is autogenerated. Do not edit manually! -->
# <code>[pixi](../../pixi.md) [global](../global.md) add</code>

## About
Adds dependencies to an environment

--8<-- "docs/reference/cli/pixi/global/add_extender:description"

## Usage
```
pixi global add [OPTIONS] --environment <ENVIRONMENT> [PACKAGE]...
```

## Arguments
- <a id="arg-<PACKAGE>" href="#arg-<PACKAGE>">`<PACKAGE>`</a>
:  The dependency as names, conda MatchSpecs
<br>May be provided more than once.

## Options
- <a id="arg---path" href="#arg---path">`--path <PATH>`</a>
:  The path to the local package
- <a id="arg---environment" href="#arg---environment">`--environment (-e) <ENVIRONMENT>`</a>
:  Specifies the environment that the dependencies need to be added to
<br>**required**: `true`
- <a id="arg---expose" href="#arg---expose">`--expose <EXPOSE>`</a>
:  Add one or more mapping which describe which executables are exposed. The syntax is `exposed_name=executable_name`, so for example `python3.10=python`. Alternatively, you can input only an executable_name and `executable_name=executable_name` is assumed
<br>May be provided more than once.

## Config Options
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---pinning-strategy" href="#arg---pinning-strategy">`--pinning-strategy <PINNING_STRATEGY>`</a>
:  Set pinning strategy
<br>**options**: `semver`, `minor`, `major`, `latest-up`, `exact-version`, `no-pin`
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---run-post-link-scripts" href="#arg---run-post-link-scripts">`--run-post-link-scripts`</a>
:  Run post-link scripts (insecure)
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---use-environment-activation-cache" href="#arg---use-environment-activation-cache">`--use-environment-activation-cache`</a>
:  Use environment activation cache (experimental)

## Git Options
- <a id="arg---git" href="#arg---git">`--git <GIT>`</a>
:  The git url, e.g. `https://github.com/user/repo.git`
- <a id="arg---branch" href="#arg---branch">`--branch <BRANCH>`</a>
:  The git branch
- <a id="arg---tag" href="#arg---tag">`--tag <TAG>`</a>
:  The git tag
- <a id="arg---rev" href="#arg---rev">`--rev <REV>`</a>
:  The git revision
- <a id="arg---subdir" href="#arg---subdir">`--subdir <SUBDIR>`</a>
:  The subdirectory within the git repository

## Description
Adds dependencies to an environment

Example:

- `pixi global add --environment python numpy`
- `pixi global add --environment my_env pytest pytest-cov --expose pytest=pytest`


--8<-- "docs/reference/cli/pixi/global/add_extender:example"
