/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceTypeDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.ResourceTypeRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.navigator.project.ProjectExplorerView;

public class SQLEditorHandlerShowScripts
extends SQLEditorHandlerOpenEditor {
    private static final Log log = Log.getLog(SQLEditorHandlerShowScripts.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBNProject projectNode;
        void rcpProject;
        block8: {
            DBPProject project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
            if (!(project instanceof RCPProject)) {
                return null;
            }
            RCPProject rCPProject = (RCPProject)project;
            projectNode = NavigatorViewBase.getGlobalNavigatorModel().getRoot().getProjectNode((DBPProject)rcpProject);
            if (projectNode != null && rcpProject.hasRealmPermission("project-resource-view")) break block8;
            return null;
        }
        try {
            DBPDataSourceContainer ds = SQLEditorHandlerShowScripts.getActiveDataSourceContainer((ExecutionEvent)event, (boolean)true);
            if (ds != null) {
                SQLNavigatorContext context = new SQLNavigatorContext((DBSObject)ds);
                SQLEditorUtils.ResourceInfo res = SQLEditorUtils.findRecentScript((RCPProject)rcpProject, context);
                if (res != null) {
                    SQLEditorHandlerShowScripts.showResourceInExplorer(event, projectNode, res.getResource());
                }
            } else {
                IResource scriptsRoot;
                IContainer rootResource;
                DBPResourceTypeDescriptor resourceType = ResourceTypeRegistry.getInstance().getResourceType("sql-script");
                String defaultRoot = resourceType.getDefaultRoot((DBPProject)rcpProject);
                if (defaultRoot != null && (rootResource = rcpProject.getRootResource()) != null && (scriptsRoot = rootResource.findMember(defaultRoot)) instanceof IFolder) {
                    SQLEditorHandlerShowScripts.showResourceInExplorer(event, projectNode, scriptsRoot);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return null;
    }

    private static boolean showResourceInExplorer(ExecutionEvent event, DBNProject projectNode, IResource resource1) throws PartInitException {
        DBNResource resource = NavigatorResources.findResource((DBNNode)projectNode, (IResource)resource1);
        if (resource != null) {
            ProjectExplorerView projectExplorer = SQLEditorHandlerShowScripts.getProjectExplorerView(event);
            if (projectExplorer != null) {
                projectExplorer.showNode((DBNNode)resource);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static ProjectExplorerView getProjectExplorerView(ExecutionEvent event) throws PartInitException {
        ProjectExplorerView projectExplorer;
        IWorkbenchWindow ww = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ProjectExplorerView projectExplorerView = projectExplorer = ww == null ? null : (ProjectExplorerView)ww.getActivePage().showView("org.jkiss.dbeaver.core.projectExplorer");
        if (projectExplorer == null) {
            return null;
        }
        return projectExplorer;
    }
}

