/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeNotebookDocumentParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DidCloseNotebookDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenNotebookDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveNotebookDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeCapabilities;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.NotebookDocumentService;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.ide.server.BuildManager;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ICapabilitiesContributor;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.ILanguageServerExtension;
import org.eclipse.xtext.ide.server.ILanguageServerShutdownAndExitHandler;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.ide.server.codelens.ICodeLensResolver;
import org.eclipse.xtext.ide.server.codelens.ICodeLensService;
import org.eclipse.xtext.ide.server.commands.ExecutableCommandRegistry;
import org.eclipse.xtext.ide.server.concurrent.RequestManager;
import org.eclipse.xtext.ide.server.contentassist.ContentAssistService;
import org.eclipse.xtext.ide.server.findReferences.WorkspaceResourceAccess;
import org.eclipse.xtext.ide.server.folding.FoldingRangeService;
import org.eclipse.xtext.ide.server.formatting.FormattingService;
import org.eclipse.xtext.ide.server.hover.IHoverService;
import org.eclipse.xtext.ide.server.occurrences.IDocumentHighlightService;
import org.eclipse.xtext.ide.server.rename.IRenameService2;
import org.eclipse.xtext.ide.server.semantictokens.SemanticTokensService;
import org.eclipse.xtext.ide.server.signatureHelp.ISignatureHelpService;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.HierarchicalDocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.IDocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.WorkspaceSymbolService;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.BufferedCancelIndicator;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class LanguageServerImpl
implements LanguageServer,
WorkspaceService,
TextDocumentService,
NotebookDocumentService,
LanguageClientAware,
Endpoint,
JsonRpcMethodProvider,
ILanguageServerAccess.IBuildListener {
    private static final Logger LOG = Logger.getLogger(LanguageServerImpl.class);
    @Inject
    private RequestManager requestManager;
    @Inject
    private WorkspaceSymbolService workspaceSymbolService;
    @Inject
    private UriExtensions uriExtensions;
    @Inject
    private IResourceServiceProvider.Registry languagesRegistry;
    @Inject
    private ExecutableCommandRegistry commandRegistry;
    @Inject
    private ILanguageServerShutdownAndExitHandler shutdownAndExitHandler;
    @Inject
    private SemanticTokensService semanticTokensService;
    private WorkspaceManager workspaceManager;
    private InitializeParams initializeParams;
    private InitializeResult initializeResult;
    private WorkspaceResourceAccess resourceAccess;
    private LanguageClient client;
    private volatile Map<String, JsonRpcMethod> supportedMethods;
    private final CompletableFuture<InitializedParams> initialized = new CompletableFuture();
    private final Multimap<String, Endpoint> extensionProviders = LinkedListMultimap.create();
    private final ILanguageServerAccess access = new ILanguageServerAccess(){

        @Override
        public <T> CompletableFuture<T> doRead(String uri, Function<ILanguageServerAccess.Context, T> function) {
            return LanguageServerImpl.this.requestManager.runRead(cancelIndicator -> LanguageServerImpl.this.workspaceManager.doRead(LanguageServerImpl.this.uriExtensions.toUri(uri), (document, resource) -> function.apply(new ILanguageServerAccess.Context((Resource)resource, (Document)document, LanguageServerImpl.this.workspaceManager.isDocumentOpen(resource.getURI()), (CancelIndicator)cancelIndicator))));
        }

        @Override
        public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
            LanguageServerImpl.this.workspaceManager.addBuildListener(listener);
        }

        @Override
        public void removeBuildListener(ILanguageServerAccess.IBuildListener listener) {
            LanguageServerImpl.this.workspaceManager.removeBuildListener(listener);
        }

        @Override
        public LanguageClient getLanguageClient() {
            return LanguageServerImpl.this.client;
        }

        @Override
        public ResourceSet newLiveScopeResourceSet(URI uri) {
            ProjectManager projectManager = LanguageServerImpl.this.workspaceManager.getProjectManager(uri);
            return projectManager.createLiveScopeResourceSet();
        }

        @Override
        public InitializeParams getInitializeParams() {
            return LanguageServerImpl.this.initializeParams;
        }

        @Override
        public <T> CompletableFuture<T> doReadIndex(Function<? super ILanguageServerAccess.IndexContext, ? extends T> function) {
            return LanguageServerImpl.this.requestManager.runRead(cancelIndicator -> function.apply(new ILanguageServerAccess.IndexContext(LanguageServerImpl.this.workspaceManager.getIndex(), (CancelIndicator)cancelIndicator)));
        }

        @Override
        public InitializeResult getInitializeResult() {
            return LanguageServerImpl.this.initializeResult;
        }

        @Override
        public <T> T doSyncRead(String uri, Function<ILanguageServerAccess.Context, T> function) {
            return LanguageServerImpl.this.workspaceManager.doRead(LanguageServerImpl.this.uriExtensions.toUri(uri), (document, resource) -> function.apply(new ILanguageServerAccess.Context((Resource)resource, (Document)document, LanguageServerImpl.this.workspaceManager.isDocumentOpen(resource.getURI()), CancelIndicator.NullImpl)));
        }
    };

    @Inject
    public void setWorkspaceManager(WorkspaceManager manager) {
        this.workspaceManager = manager;
        this.resourceAccess = new WorkspaceResourceAccess(this.workspaceManager);
    }

    private Set<? extends IResourceServiceProvider> getAllLanguages() {
        TreeMap<String, IResourceServiceProvider> sorted = new TreeMap<String, IResourceServiceProvider>();
        for (String ext : this.languagesRegistry.getExtensionToFactoryMap().keySet()) {
            sorted.put(ext, this.languagesRegistry.getResourceServiceProvider(URI.createURI((String)("synth:///file." + ext))));
        }
        return ImmutableSet.copyOf(sorted.values());
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        if (this.initializeParams != null) {
            throw new IllegalStateException("This language server has already been initialized.");
        }
        if (this.languagesRegistry.getExtensionToFactoryMap().isEmpty()) {
            throw new IllegalStateException("No Xtext languages have been registered. Please make sure you have added the languages's setup class in '/META-INF/services/org.eclipse.xtext.ISetup'");
        }
        this.initializeParams = params;
        InitializeResult result = new InitializeResult();
        result.setCapabilities(this.createServerCapabilities(params));
        this.access.addBuildListener(this);
        return this.requestManager.runWrite(() -> {
            if (this.clientSupportsWorkspaceFolders() && this.workspaceManager.isSupportsWorkspaceFolders()) {
                List<WorkspaceFolder> workspaceFolders = params.getWorkspaceFolders();
                if (workspaceFolders == null) {
                    workspaceFolders = Collections.emptyList();
                }
                this.workspaceManager.initialize(workspaceFolders, (Procedures.Procedure2<? super URI, ? super Iterable<Issue>>)((Procedures.Procedure2)this::publishDiagnostics), CancelIndicator.NullImpl);
            } else {
                URI baseDir = this.getBaseDir(params);
                this.workspaceManager.initialize(baseDir, (Procedures.Procedure2<? super URI, ? super Iterable<Issue>>)((Procedures.Procedure2)this::publishDiagnostics), CancelIndicator.NullImpl);
            }
            return result;
        }, (cancelIndicator, it) -> it).thenApply(it -> {
            this.initializeResult = it;
            return this.initializeResult;
        });
    }

    protected boolean clientSupportsWorkspaceFolders() {
        return this.initializeParams.getCapabilities() != null && this.initializeParams.getCapabilities().getWorkspace() != null && Objects.equals(this.initializeParams.getCapabilities().getWorkspace().getWorkspaceFolders(), Boolean.TRUE);
    }

    protected ServerCapabilities createServerCapabilities(InitializeParams params) {
        boolean clientPrepareSupport;
        ServerCapabilities serverCapabilities = new ServerCapabilities();
        serverCapabilities.setHoverProvider(Boolean.valueOf(true));
        serverCapabilities.setDefinitionProvider(Boolean.valueOf(true));
        serverCapabilities.setReferencesProvider(Boolean.valueOf(true));
        serverCapabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
        serverCapabilities.setWorkspaceSymbolProvider(Boolean.valueOf(true));
        Set<? extends IResourceServiceProvider> allLanguages = this.getAllLanguages();
        if (allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(ICodeLensService.class) != null)) {
            CodeLensOptions codeLensOptions = new CodeLensOptions();
            codeLensOptions.setResolveProvider(Boolean.valueOf(allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(ICodeLensResolver.class) != null)));
            serverCapabilities.setCodeLensProvider(codeLensOptions);
        }
        serverCapabilities.setCodeActionProvider(Boolean.valueOf(allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(ICodeActionService2.class) != null)));
        serverCapabilities.setSignatureHelpProvider(new SignatureHelpOptions((List)ImmutableList.of((Object)"(", (Object)",")));
        serverCapabilities.setTextDocumentSync(TextDocumentSyncKind.Incremental);
        SemanticTokensLegend legend = new SemanticTokensLegend(this.semanticTokensService.getTokenTypes(), this.semanticTokensService.getTokenModifiers());
        SemanticTokensWithRegistrationOptions semanticTokensWithRegistrationOptions = new SemanticTokensWithRegistrationOptions(legend);
        semanticTokensWithRegistrationOptions.setFull(Boolean.valueOf(true));
        semanticTokensWithRegistrationOptions.setRange(Boolean.valueOf(false));
        serverCapabilities.setSemanticTokensProvider(semanticTokensWithRegistrationOptions);
        CompletionOptions completionOptions = new CompletionOptions();
        completionOptions.setResolveProvider(Boolean.valueOf(false));
        completionOptions.setTriggerCharacters((List)ImmutableList.of((Object)"."));
        serverCapabilities.setCompletionProvider(completionOptions);
        serverCapabilities.setDocumentFormattingProvider(Boolean.valueOf(true));
        serverCapabilities.setDocumentRangeFormattingProvider(Boolean.valueOf(true));
        serverCapabilities.setDocumentHighlightProvider(Boolean.valueOf(true));
        ClientCapabilities clientCapabilities = null;
        if (params != null) {
            clientCapabilities = params.getCapabilities();
        }
        TextDocumentClientCapabilities textDocument = null;
        if (clientCapabilities != null) {
            textDocument = clientCapabilities.getTextDocument();
        }
        RenameCapabilities rename = null;
        FoldingRangeCapabilities folding = null;
        if (textDocument != null) {
            rename = textDocument.getRename();
            folding = textDocument.getFoldingRange();
        }
        if (folding != null) {
            serverCapabilities.setFoldingRangeProvider(Boolean.valueOf(allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(FoldingRangeService.class) != null)));
        }
        Boolean prepareSupport = null;
        if (rename != null) {
            prepareSupport = rename.getPrepareSupport();
        }
        if ((clientPrepareSupport = Objects.equals(Boolean.TRUE, prepareSupport)) && allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(IRenameService2.class) != null)) {
            RenameOptions renameOptions = new RenameOptions();
            renameOptions.setPrepareProvider(Boolean.valueOf(true));
            serverCapabilities.setRenameProvider(Either.forRight((Object)renameOptions));
        } else {
            serverCapabilities.setRenameProvider(Either.forLeft((Object)allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(IRenameService2.class) != null)));
        }
        WorkspaceClientCapabilities workspace = null;
        if (clientCapabilities != null) {
            workspace = clientCapabilities.getWorkspace();
        }
        ExecuteCommandCapabilities executeCommand = null;
        if (workspace != null) {
            executeCommand = workspace.getExecuteCommand();
            if (workspace.getWorkspaceFolders() == Boolean.TRUE && this.workspaceManager.isSupportsWorkspaceFolders()) {
                WorkspaceFoldersOptions workspaceFoldersOptions = new WorkspaceFoldersOptions();
                workspaceFoldersOptions.setSupported(Boolean.valueOf(true));
                workspaceFoldersOptions.setChangeNotifications(Boolean.valueOf(true));
                serverCapabilities.setWorkspace(new WorkspaceServerCapabilities(workspaceFoldersOptions));
            }
        }
        if (executeCommand != null) {
            this.commandRegistry.initialize(allLanguages, clientCapabilities, this.client);
            ExecuteCommandOptions executeCommandOptions = new ExecuteCommandOptions();
            executeCommandOptions.setCommands(this.commandRegistry.getCommands());
            serverCapabilities.setExecuteCommandProvider(executeCommandOptions);
        }
        for (IResourceServiceProvider iResourceServiceProvider : allLanguages) {
            ICapabilitiesContributor capabilitiesContributor = (ICapabilitiesContributor)iResourceServiceProvider.get(ICapabilitiesContributor.class);
            if (capabilitiesContributor == null) continue;
            capabilitiesContributor.contribute(serverCapabilities, params);
        }
        return serverCapabilities;
    }

    public void initialized(InitializedParams params) {
        this.initialized.complete(params);
    }

    @Deprecated
    private URI deprecatedToBaseDir(InitializeParams params) {
        String rootPath = params.getRootPath();
        if (rootPath != null) {
            return this.uriExtensions.toUri(this.uriExtensions.toUriString(URI.createFileURI((String)rootPath)));
        }
        return null;
    }

    @Deprecated
    protected URI getBaseDir(InitializeParams params) {
        String rootUri = params.getRootUri();
        if (rootUri != null) {
            return this.uriExtensions.toUri(rootUri);
        }
        return this.deprecatedToBaseDir(params);
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public void exit() {
        this.shutdownAndExitHandler.exit();
    }

    public CompletableFuture<Object> shutdown() {
        this.shutdownAndExitHandler.shutdown();
        return CompletableFuture.completedFuture(new Object());
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    public NotebookDocumentService getNotebookDocumentService() {
        return this;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.runBuildable(() -> this.toBuildable(params));
    }

    protected BuildManager.Buildable toBuildable(DidOpenTextDocumentParams params) {
        TextDocumentItem textDocument = params.getTextDocument();
        return this.workspaceManager.didOpen(this.getURI(textDocument), textDocument.getVersion(), textDocument.getText());
    }

    public void didChange(DidChangeTextDocumentParams params) {
        this.runBuildable(() -> this.toBuildable(params));
    }

    protected BuildManager.Buildable toBuildable(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier textDocument = params.getTextDocument();
        return this.workspaceManager.didChangeTextDocumentContent(this.getURI((TextDocumentIdentifier)textDocument), textDocument.getVersion(), params.getContentChanges());
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.runBuildable(() -> this.toBuildable(params));
    }

    protected BuildManager.Buildable toBuildable(DidCloseTextDocumentParams params) {
        return this.workspaceManager.didClose(this.getURI(params.getTextDocument()));
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.runBuildable(() -> this.toBuildable(params));
    }

    protected BuildManager.Buildable toBuildable(DidChangeWatchedFilesParams params) {
        ArrayList<URI> dirtyFiles = new ArrayList<URI>();
        ArrayList<URI> deletedFiles = new ArrayList<URI>();
        params.getChanges().stream().map(fileEvent -> Pair.of((Object)this.uriExtensions.toUri(fileEvent.getUri()), (Object)fileEvent.getType())).filter(pair -> !this.workspaceManager.isDocumentOpen((URI)pair.getKey())).forEach(pair -> {
            if (pair.getValue() == FileChangeType.Deleted) {
                deletedFiles.add((URI)pair.getKey());
            } else {
                dirtyFiles.add((URI)pair.getKey());
            }
        });
        return this.workspaceManager.didChangeFiles(dirtyFiles, deletedFiles);
    }

    protected void runBuildable(Supplier<? extends BuildManager.Buildable> newBuildable) {
        this.requestManager.runWrite(newBuildable::get, (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator));
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.requestManager.runWrite(() -> {
            this.workspaceManager.refreshWorkspaceConfig(CancelIndicator.NullImpl);
            return null;
        }, (a, b) -> null);
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.requestManager.runWrite(() -> {
            this.workspaceManager.didChangeWorkspaceFolders(params, CancelIndicator.NullImpl);
            return null;
        }, (a, b) -> null);
    }

    private void publishDiagnostics(URI uri, Iterable<? extends Issue> issues) {
        this.initialized.thenAccept(initParams -> {
            PublishDiagnosticsParams publishDiagnosticsParams = new PublishDiagnosticsParams();
            publishDiagnosticsParams.setUri(this.uriExtensions.toUriString(uri));
            publishDiagnosticsParams.setDiagnostics(this.toDiagnostics(issues));
            this.client.publishDiagnostics(publishDiagnosticsParams);
        });
    }

    protected List<Diagnostic> toDiagnostics(Iterable<? extends Issue> issues) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        for (Issue issue : issues) {
            if (issue.getSeverity() == Severity.IGNORE) continue;
            result.add(this.toDiagnostic(issue));
        }
        return result;
    }

    protected Diagnostic toDiagnostic(Issue issue) {
        Diagnostic result = new Diagnostic();
        result.setCode(issue.getCode());
        result.setData((Object)issue.getData());
        result.setMessage(issue.getMessage());
        result.setSeverity(this.toDiagnosticSeverity(issue.getSeverity()));
        Position start = new Position(Math.max(0, issue.getLineNumber() - 1), Math.max(0, issue.getColumn() - 1));
        Position end = new Position(Math.max(0, issue.getLineNumberEnd() - 1), Math.max(0, issue.getColumnEnd() - 1));
        result.setRange(new Range(start, end));
        return result;
    }

    protected DiagnosticSeverity toDiagnosticSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return DiagnosticSeverity.Error;
            }
            case IGNORE: {
                return DiagnosticSeverity.Hint;
            }
            case INFO: {
                return DiagnosticSeverity.Information;
            }
            case WARNING: {
                return DiagnosticSeverity.Warning;
            }
        }
        return DiagnosticSeverity.Hint;
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.completion((CancelIndicator)cancelIndicator, params));
    }

    protected Either<List<CompletionItem>, CompletionList> completion(CancelIndicator originalCancelIndicator, CompletionParams params) {
        URI uri = this.getURI((TextDocumentPositionParams)params);
        ContentAssistService contentAssistService = this.getService(uri, ContentAssistService.class);
        if (contentAssistService == null) {
            return Either.forRight((Object)new CompletionList());
        }
        BufferedCancelIndicator cancelIndicator = new BufferedCancelIndicator(originalCancelIndicator);
        return Either.forRight((Object)((CompletionList)this.workspaceManager.doRead(uri, (doc, res) -> contentAssistService.createCompletionList((Document)doc, (XtextResource)res, params, (CancelIndicator)cancelIndicator))));
    }

    protected URI getURI(TextDocumentPositionParams params) {
        return this.getURI(params.getTextDocument());
    }

    protected URI getURI(TextDocumentIdentifier documentIdentifier) {
        return this.uriExtensions.toUri(documentIdentifier.getUri());
    }

    protected URI getURI(TextDocumentItem documentItem) {
        return this.uriExtensions.toUri(documentItem.getUri());
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.definition(params, (CancelIndicator)cancelIndicator));
    }

    protected Either<List<? extends Location>, List<? extends LocationLink>> definition(DefinitionParams params, CancelIndicator cancelIndicator) {
        return Either.forLeft(this.definition(cancelIndicator, params));
    }

    protected List<? extends Location> definition(CancelIndicator cancelIndicator, DefinitionParams params) {
        URI uri = this.getURI((TextDocumentPositionParams)params);
        DocumentSymbolService documentSymbolService = this.getService(uri, DocumentSymbolService.class);
        if (documentSymbolService == null) {
            return Collections.emptyList();
        }
        return (List)this.workspaceManager.doRead(uri, (doc, res) -> documentSymbolService.getDefinitions((Document)doc, (XtextResource)res, params, this.resourceAccess, cancelIndicator));
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.references(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends Location> references(ReferenceParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI((TextDocumentPositionParams)params);
        DocumentSymbolService documentSymbolService = this.getService(uri, DocumentSymbolService.class);
        if (documentSymbolService == null) {
            return Collections.emptyList();
        }
        return (List)this.workspaceManager.doRead(uri, (document, resource) -> documentSymbolService.getReferences((Document)document, (XtextResource)resource, params, this.resourceAccess, this.workspaceManager.getIndex(), cancelIndicator));
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return this.requestManager.runRead(cancelIndicator -> {
            List<DocumentSymbol> symbols = this.documentSymbol(params, (CancelIndicator)cancelIndicator);
            return Lists.transform(symbols, Either::forRight);
        });
    }

    protected List<DocumentSymbol> documentSymbol(DocumentSymbolParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        IDocumentSymbolService documentSymbolService = this.getIDocumentSymbolService(this.getResourceServiceProvider(uri));
        if (documentSymbolService == null) {
            return Collections.emptyList();
        }
        return (List)this.workspaceManager.doRead(uri, (document, resource) -> documentSymbolService.getSymbols((Document)document, (XtextResource)resource, params, cancelIndicator));
    }

    protected IDocumentSymbolService getIDocumentSymbolService(IResourceServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            return null;
        }
        if (this.isHierarchicalDocumentSymbolSupport()) {
            return (IDocumentSymbolService)serviceProvider.get(HierarchicalDocumentSymbolService.class);
        }
        return (IDocumentSymbolService)serviceProvider.get(DocumentSymbolService.class);
    }

    protected boolean isHierarchicalDocumentSymbolSupport() {
        ClientCapabilities capabilities = this.initializeParams.getCapabilities();
        if (capabilities == null) {
            return false;
        }
        TextDocumentClientCapabilities textDocument = capabilities.getTextDocument();
        if (textDocument == null) {
            return false;
        }
        DocumentSymbolCapabilities documentSymbol = textDocument.getDocumentSymbol();
        if (documentSymbol == null) {
            return false;
        }
        Boolean hierarchicalDocumentSymbolSupport = documentSymbol.getHierarchicalDocumentSymbolSupport();
        if (hierarchicalDocumentSymbolSupport == null) {
            return false;
        }
        return hierarchicalDocumentSymbolSupport;
    }

    public CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> symbol(WorkspaceSymbolParams params) {
        return this.requestManager.runRead(cancelIndicator -> {
            List<? extends WorkspaceSymbol> symbols = this.symbol(params, (CancelIndicator)cancelIndicator);
            return Either.forRight(symbols);
        });
    }

    protected List<? extends WorkspaceSymbol> symbol(WorkspaceSymbolParams params, CancelIndicator cancelIndicator) {
        return this.workspaceSymbolService.getSymbols(params.getQuery(), this.resourceAccess, this.workspaceManager.getIndex(), cancelIndicator);
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.hover(params, (CancelIndicator)cancelIndicator));
    }

    protected Hover hover(HoverParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI((TextDocumentPositionParams)params);
        IHoverService hoverService = this.getService(uri, IHoverService.class);
        if (hoverService == null) {
            return IHoverService.EMPTY_HOVER;
        }
        return (Hover)this.workspaceManager.doRead(uri, (document, resource) -> hoverService.hover((Document)document, (XtextResource)resource, params, cancelIndicator));
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.signatureHelp(params, (CancelIndicator)cancelIndicator));
    }

    protected SignatureHelp signatureHelp(SignatureHelpParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI((TextDocumentPositionParams)params);
        ISignatureHelpService helper = this.getService(uri, ISignatureHelpService.class);
        if (helper == null) {
            return ISignatureHelpService.EMPTY;
        }
        return (SignatureHelp)this.workspaceManager.doRead(uri, (doc, resource) -> helper.getSignatureHelp((Document)doc, (XtextResource)resource, params, cancelIndicator));
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.documentHighlight(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends DocumentHighlight> documentHighlight(DocumentHighlightParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI((TextDocumentPositionParams)params);
        IDocumentHighlightService service = this.getService(uri, IDocumentHighlightService.class);
        if (service == null) {
            return Collections.emptyList();
        }
        return (List)this.workspaceManager.doRead(uri, (doc, resource) -> service.getDocumentHighlights((Document)doc, (XtextResource)resource, params, cancelIndicator));
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.codeAction(params, (CancelIndicator)cancelIndicator));
    }

    protected List<Either<Command, CodeAction>> codeAction(CodeActionParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        IResourceServiceProvider serviceProvider = this.getResourceServiceProvider(uri);
        ICodeActionService2 codeActionService = this.getService(serviceProvider, ICodeActionService2.class);
        if (codeActionService == null) {
            return Collections.emptyList();
        }
        ICodeActionService2.Options options = new ICodeActionService2.Options();
        options.setURI(params.getTextDocument().getUri());
        options.setLanguageServerAccess(this.access);
        options.setCodeActionParams(params);
        options.setCancelIndicator(cancelIndicator);
        List<Either<Command, CodeAction>> actions = codeActionService.getCodeActions(options);
        if (actions != null) {
            return actions;
        }
        return Collections.emptyList();
    }

    protected void installURI(List<? extends CodeLens> codeLenses, String uri) {
        for (CodeLens codeLens : codeLenses) {
            Object data = codeLens.getData();
            if (data != null) {
                codeLens.setData(Arrays.asList(uri, codeLens.getData()));
                continue;
            }
            codeLens.setData((Object)uri);
        }
    }

    protected URI uninstallURI(CodeLens lens) {
        URI result = null;
        Object data = lens.getData();
        if (data instanceof String) {
            result = URI.createURI((String)data.toString());
            lens.setData(null);
        } else if (data instanceof List) {
            List l = (List)data;
            result = URI.createURI((String)l.get(0).toString());
            lens.setData(l.get(1));
        }
        return result;
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.codeLens(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends CodeLens> codeLens(CodeLensParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        ICodeLensService codeLensService = this.getService(uri, ICodeLensService.class);
        if (codeLensService == null) {
            return Collections.emptyList();
        }
        return (List)this.workspaceManager.doRead(uri, (document, resource) -> {
            List<? extends CodeLens> result = codeLensService.computeCodeLenses((Document)document, (XtextResource)resource, params, cancelIndicator);
            this.installURI(result, uri.toString());
            return result;
        });
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        URI uri = this.uninstallURI(unresolved);
        if (uri == null) {
            return CompletableFuture.completedFuture(unresolved);
        }
        return this.requestManager.runRead(cancelIndicator -> this.resolveCodeLens(uri, unresolved, (CancelIndicator)cancelIndicator));
    }

    protected CodeLens resolveCodeLens(URI uri, CodeLens unresolved, CancelIndicator cancelIndicator) {
        ICodeLensResolver resolver = this.getService(uri, ICodeLensResolver.class);
        if (resolver == null) {
            return unresolved;
        }
        return (CodeLens)this.workspaceManager.doRead(uri, (document, resource) -> resolver.resolveCodeLens((Document)document, (XtextResource)resource, unresolved, cancelIndicator));
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.formatting(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends TextEdit> formatting(DocumentFormattingParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        FormattingService formatterService = this.getService(uri, FormattingService.class);
        if (formatterService == null) {
            return Collections.emptyList();
        }
        return (List)this.workspaceManager.doRead(uri, (document, resource) -> formatterService.format((Document)document, (XtextResource)resource, params, cancelIndicator));
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.rangeFormatting(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends TextEdit> rangeFormatting(DocumentRangeFormattingParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        FormattingService formatterService = this.getService(uri, FormattingService.class);
        if (formatterService == null) {
            return Collections.emptyList();
        }
        return (List)this.workspaceManager.doRead(uri, (document, resource) -> formatterService.format((Document)document, (XtextResource)resource, params, cancelIndicator));
    }

    protected <Service> Service getService(URI uri, Class<Service> type) {
        return this.getService(this.getResourceServiceProvider(uri), type);
    }

    protected <Service> Service getService(IResourceServiceProvider resourceServiceProvider, Class<Service> type) {
        if (resourceServiceProvider == null) {
            return null;
        }
        return (Service)resourceServiceProvider.get(type);
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.executeCommand(params, (CancelIndicator)cancelIndicator));
    }

    protected Object executeCommand(ExecuteCommandParams params, CancelIndicator cancelIndicator) {
        return this.commandRegistry.executeCommand(params, this.access, cancelIndicator);
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams renameParams) {
        return this.requestManager.runRead(cancelIndicator -> this.rename(renameParams, (CancelIndicator)cancelIndicator));
    }

    protected WorkspaceEdit rename(RenameParams renameParams, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(renameParams.getTextDocument());
        IResourceServiceProvider resourceServiceProvider = this.getResourceServiceProvider(uri);
        IRenameService2 renameService2 = this.getService(resourceServiceProvider, IRenameService2.class);
        if (renameService2 != null) {
            IRenameService2.Options options = new IRenameService2.Options();
            options.setLanguageServerAccess(this.access);
            options.setRenameParams(renameParams);
            options.setCancelIndicator(cancelIndicator);
            return renameService2.rename(options);
        }
        return new WorkspaceEdit();
    }

    protected IResourceServiceProvider getResourceServiceProvider(URI uri) {
        return this.languagesRegistry.getResourceServiceProvider(uri);
    }

    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.prepareRename(params, (CancelIndicator)cancelIndicator));
    }

    protected Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior> prepareRename(PrepareRenameParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI((TextDocumentPositionParams)params);
        IRenameService2 renameService = this.getService(uri, IRenameService2.class);
        if (renameService == null) {
            throw new UnsupportedOperationException();
        }
        IRenameService2.PrepareRenameOptions options = new IRenameService2.PrepareRenameOptions();
        options.setLanguageServerAccess(this.access);
        options.setParams(params);
        options.setCancelIndicator(cancelIndicator);
        return renameService.prepareRename(options);
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return this.requestManager.runRead(cancelIndicator -> this.foldingRange(params, (CancelIndicator)cancelIndicator));
    }

    protected List<FoldingRange> foldingRange(FoldingRangeRequestParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        FoldingRangeService foldingRangeService = this.getService(uri, FoldingRangeService.class);
        if (foldingRangeService == null) {
            return Lists.newArrayList();
        }
        return (List)this.workspaceManager.doRead(uri, (document, resource) -> foldingRangeService.createFoldingRanges((Document)document, (XtextResource)resource, cancelIndicator));
    }

    public void notify(String method, Object parameter) {
        for (Endpoint endpoint : this.extensionProviders.get((Object)method)) {
            try {
                endpoint.notify(method, parameter);
            }
            catch (UnsupportedOperationException e) {
                if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                throw e;
            }
        }
    }

    public CompletableFuture<?> request(String method, Object parameter) {
        if (!this.extensionProviders.containsKey((Object)method)) {
            throw new UnsupportedOperationException("The json request '" + method + "' is unknown.");
        }
        for (Endpoint endpoint : this.extensionProviders.get((Object)method)) {
            try {
                return endpoint.request(method, parameter);
            }
            catch (UnsupportedOperationException e) {
                if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JsonRpcMethod> supportedMethods() {
        if (this.supportedMethods != null) {
            return this.supportedMethods;
        }
        Multimap<String, Endpoint> multimap = this.extensionProviders;
        synchronized (multimap) {
            LinkedHashMap<String, JsonRpcMethod> supportedMethods = new LinkedHashMap<String, JsonRpcMethod>();
            supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(this.getClass()));
            LinkedHashMap<String, JsonRpcMethod> extensions = new LinkedHashMap<String, JsonRpcMethod>();
            for (IResourceServiceProvider iResourceServiceProvider : this.getAllLanguages()) {
                ILanguageServerExtension ext = (ILanguageServerExtension)iResourceServiceProvider.get(ILanguageServerExtension.class);
                if (ext == null) continue;
                ext.initialize(this.access);
                Map supportedExtensions = ext instanceof JsonRpcMethodProvider ? ((JsonRpcMethodProvider)ext).supportedMethods() : ServiceEndpoints.getSupportedMethods(ext.getClass());
                for (Map.Entry entry : supportedExtensions.entrySet()) {
                    if (supportedMethods.containsKey(entry.getKey())) {
                        LOG.error((Object)("The json rpc method '" + (String)entry.getKey() + "' can not be an extension as it is already defined in the LSP standard."));
                        continue;
                    }
                    JsonRpcMethod existing = extensions.put((String)entry.getKey(), (JsonRpcMethod)entry.getValue());
                    if (existing != null && !Objects.equals(existing, entry.getValue())) {
                        LOG.error((Object)("An incompatible LSP extension '" + (String)entry.getKey() + "' has already been registered. Using 1 ignoring 2. \n1 : " + String.valueOf(existing) + " \n2 : " + String.valueOf(entry.getValue())));
                        extensions.put((String)entry.getKey(), existing);
                        continue;
                    }
                    Endpoint endpoint = ServiceEndpoints.toEndpoint((Object)ext);
                    this.extensionProviders.put((Object)((String)entry.getKey()), (Object)endpoint);
                    supportedMethods.put((String)entry.getKey(), (JsonRpcMethod)entry.getValue());
                }
            }
            this.supportedMethods = supportedMethods;
            return supportedMethods;
        }
    }

    @Override
    @Deprecated
    public void afterBuild(List<IResourceDescription.Delta> deltas) {
    }

    protected ILanguageServerAccess getLanguageServerAccess() {
        return this.access;
    }

    protected LanguageClient getLanguageClient() {
        return this.client;
    }

    protected ExecutableCommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    protected Multimap<String, Endpoint> getExtensionProviders() {
        return ImmutableMultimap.copyOf(this.extensionProviders);
    }

    protected Map<String, JsonRpcMethod> getSupportedMethods() {
        return ImmutableMap.copyOf(this.supportedMethods);
    }

    protected IResourceServiceProvider.Registry getLanguagesRegistry() {
        return this.languagesRegistry;
    }

    protected IReferenceFinder.IResourceAccess getWorkspaceResourceAccess() {
        return this.resourceAccess;
    }

    protected WorkspaceManager getWorkspaceManager() {
        return this.workspaceManager;
    }

    protected WorkspaceSymbolService getWorkspaceSymbolService() {
        return this.workspaceSymbolService;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public void didOpen(DidOpenNotebookDocumentParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public void didChange(DidChangeNotebookDocumentParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public void didSave(DidSaveNotebookDocumentParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public void didClose(DidCloseNotebookDocumentParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public CompletableFuture<SemanticTokens> semanticTokensFull(SemanticTokensParams params) {
        return this.getRequestManager().runRead(cancelIndicator -> this.semanticTokensFull(params, (CancelIndicator)cancelIndicator));
    }

    @Beta
    protected SemanticTokens semanticTokensFull(SemanticTokensParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        return (SemanticTokens)this.getWorkspaceManager().doRead(uri, (doc, res) -> this.semanticTokensService.semanticTokensFull((Document)doc, (XtextResource)res, params, cancelIndicator));
    }

    static /* synthetic */ WorkspaceManager access$0(LanguageServerImpl languageServerImpl) {
        return languageServerImpl.workspaceManager;
    }

    static /* synthetic */ UriExtensions access$1(LanguageServerImpl languageServerImpl) {
        return languageServerImpl.uriExtensions;
    }
}

