/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.karaf.internal.jaas;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.openhab.core.auth.ManagedUser;
import org.openhab.core.auth.User;
import org.openhab.core.auth.UserRegistry;
import org.openhab.core.common.registry.Identifiable;

public class ManagedUserBackingEngine
implements BackingEngine {
    private final UserRegistry userRegistry;

    public ManagedUserBackingEngine(UserRegistry userRegistry) {
        this.userRegistry = userRegistry;
    }

    public void addUser(String username, String password) {
        this.userRegistry.register(username, password, new HashSet<String>(Set.of("user")));
    }

    public void deleteUser(String username) {
        this.userRegistry.remove((Object)username);
    }

    public List<UserPrincipal> listUsers() {
        return this.userRegistry.getAll().stream().map(u -> new UserPrincipal(u.getName())).toList();
    }

    public UserPrincipal lookupUser(String username) {
        User user = (User)this.userRegistry.get((Object)username);
        if (user != null) {
            return new UserPrincipal(user.getName());
        }
        return null;
    }

    public List<GroupPrincipal> listGroups(UserPrincipal user) {
        return List.of();
    }

    public Map<GroupPrincipal, String> listGroups() {
        return Map.of();
    }

    public void addGroup(String username, String group) {
        throw new UnsupportedOperationException();
    }

    public void createGroup(String group) {
        throw new UnsupportedOperationException();
    }

    public void deleteGroup(String username, String group) {
        throw new UnsupportedOperationException();
    }

    public List<RolePrincipal> listRoles(Principal principal) {
        User user = (User)this.userRegistry.get((Object)principal.getName());
        if (user != null) {
            return user.getRoles().stream().map(r -> new RolePrincipal(r)).toList();
        }
        return List.of();
    }

    public void addRole(String username, String role) {
        User user = (User)this.userRegistry.get((Object)username);
        if (user instanceof ManagedUser) {
            ManagedUser managedUser = (ManagedUser)user;
            managedUser.getRoles().add(role);
            this.userRegistry.update((Identifiable)managedUser);
        }
    }

    public void deleteRole(String username, String role) {
        User user = (User)this.userRegistry.get((Object)username);
        if (user instanceof ManagedUser) {
            ManagedUser managedUser = (ManagedUser)user;
            managedUser.getRoles().remove(role);
            this.userRegistry.update((Identifiable)managedUser);
        }
    }

    public void addGroupRole(String group, String role) {
        throw new UnsupportedOperationException();
    }

    public void deleteGroupRole(String group, String role) {
        throw new UnsupportedOperationException();
    }
}

