/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation._private;

import java.io.IOException;
import java.io.OutputStream;

public class NSMemoryOutputStream
extends OutputStream {
    protected byte[] _data;
    protected int _count;

    public NSMemoryOutputStream() {
        this(1);
    }

    public NSMemoryOutputStream(int n) {
        if (n < 1) {
            n = 1;
        }
        this._data = new byte[n];
        this._count = 0;
    }

    public NSMemoryOutputStream(byte[] byArray) {
        this._data = null == byArray ? new byte[1] : byArray;
        this._count = 0;
    }

    protected void growDataBuffer(int n) {
        int n2 = this._data.length;
        if (0 != n) {
            while (n2 <= n) {
                n2 *= 2;
            }
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this._data, 0, byArray, 0, this._data.length);
        this._data = byArray;
    }

    public void write(int n) throws IOException {
        if (this._count == this._data.length) {
            this.growDataBuffer(0);
        }
        this._data[this._count++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._count + n2 >= this._data.length) {
            this.growDataBuffer(this._count + n2);
        }
        System.arraycopy(byArray, n, this._data, this._count, n2);
        this._count += n2;
    }

    public String getBytesAsString() {
        return new String(this._data, 0, this._count);
    }
}

