/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name = "";
    String command;
    String iconPath;
    Display display;
    boolean gioExpectUri;
    static long modTime;
    static Map<String, List<String>> mimeTable;
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";

    Program() {
    }

    static String[] parseCommand(String cmd) {
        ArrayList<String> args = new ArrayList<String>();
        int sIndex = 0;
        while (sIndex < cmd.length()) {
            int eIndex;
            while (sIndex < cmd.length() && Character.isWhitespace(cmd.charAt(sIndex))) {
                ++sIndex;
            }
            if (sIndex >= cmd.length()) continue;
            if (cmd.charAt(sIndex) == '\"' || cmd.charAt(sIndex) == '\'') {
                for (eIndex = sIndex + 1; eIndex < cmd.length() && cmd.charAt(eIndex) != cmd.charAt(sIndex); ++eIndex) {
                }
                if (eIndex >= cmd.length()) {
                    args.add(cmd.substring(sIndex, eIndex));
                } else {
                    args.add(cmd.substring(sIndex + 1, eIndex));
                }
                sIndex = eIndex + 1;
                continue;
            }
            for (eIndex = sIndex; eIndex < cmd.length() && !Character.isWhitespace(cmd.charAt(eIndex)); ++eIndex) {
            }
            args.add(cmd.substring(sIndex, eIndex));
            sIndex = eIndex + 1;
        }
        return args.toArray(new String[args.size()]);
    }

    public static Program findProgram(String extension) {
        return Program.findProgram(Display.getCurrent(), extension);
    }

    static Program findProgram(Display display, String extension) {
        String mimeType;
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        if ((mimeType = Program.gio_getMimeType(extension)) == null) {
            return null;
        }
        return Program.gio_getProgram(display, mimeType);
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    public ImageData getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        ImageData data = null;
        long icon_theme = GTK.gtk_icon_theme_get_default();
        byte[] icon = Converter.wcsToMbcs(this.iconPath, true);
        long gicon = OS.g_icon_new_for_string(icon, null);
        if (gicon != 0L) {
            long gicon_info = GTK.gtk_icon_theme_lookup_by_gicon(icon_theme, gicon, 16, 0);
            if (gicon_info != 0L) {
                long pixbuf = GTK.gtk_icon_info_load_icon(gicon_info, null);
                if (pixbuf != 0L) {
                    int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
                    long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
                    int height = GDK.gdk_pixbuf_get_height(pixbuf);
                    int width = GDK.gdk_pixbuf_get_width(pixbuf);
                    boolean hasAlpha = GDK.gdk_pixbuf_get_has_alpha(pixbuf);
                    byte[] srcData = new byte[stride * height];
                    C.memmove(srcData, pixels, (long)srcData.length);
                    OS.g_object_unref(pixbuf);
                    if (hasAlpha) {
                        PaletteData palette = new PaletteData(-16777216, 0xFF0000, 65280);
                        data = new ImageData(width, height, 32, palette, 4, srcData);
                        data.bytesPerLine = stride;
                        int s = 3;
                        int a = 0;
                        byte[] alphaData = new byte[width * height];
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                alphaData[a++] = srcData[s];
                                srcData[s] = 0;
                                s += 4;
                            }
                        }
                        data.alphaData = alphaData;
                    } else {
                        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
                        data = new ImageData(width, height, 24, palette, 4, srcData);
                        data.bytesPerLine = stride;
                    }
                }
                OS.g_object_unref(gicon_info);
            }
            OS.g_object_unref(gicon);
        }
        return data;
    }

    static Map<String, List<String>> gio_getMimeInfo() {
        Path path = Paths.get("/usr/share/mime/globs", new String[0]);
        long lastModified = 0L;
        try {
            lastModified = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (modTime != 0L && modTime == lastModified) {
            return mimeTable;
        }
        try {
            mimeTable = new HashMap<String, List<String>>();
            modTime = lastModified;
            for (String line : Files.readAllLines(path)) {
                int separatorIndex = line.indexOf(58);
                if (separatorIndex <= 0) continue;
                ArrayList<String> mimeTypes = new ArrayList<String>();
                String mimeType = line.substring(0, separatorIndex);
                String extensionFormat = line.substring(separatorIndex + 1);
                int extensionIndex = extensionFormat.indexOf(46);
                if (extensionIndex <= 0) continue;
                String extension = extensionFormat.substring(extensionIndex);
                if (mimeTable.containsKey(extension)) {
                    List<String> value = mimeTable.get(extension);
                    mimeTypes.addAll(value);
                }
                mimeTypes.add(mimeType);
                mimeTable.put(extension, mimeTypes);
            }
            return mimeTable;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static String gio_getMimeType(String extension) {
        String mimeType = null;
        Map<String, List<String>> h = Program.gio_getMimeInfo();
        if (h != null && h.containsKey(extension)) {
            List<String> mimeTypes = h.get(extension);
            mimeType = mimeTypes.get(0);
        }
        return mimeType;
    }

    static Program gio_getProgram(Display display, String mimeType) {
        Program program = null;
        byte[] mimeTypeBuffer = Converter.wcsToMbcs(mimeType, true);
        long application = OS.g_app_info_get_default_for_type(mimeTypeBuffer, false);
        if (application != 0L) {
            program = Program.gio_getProgram(display, application);
        }
        return program;
    }

    static Program gio_getProgram(Display display, long application) {
        long applicationCommand;
        byte[] buffer;
        int length;
        Program program = new Program();
        program.display = display;
        long applicationName = OS.g_app_info_get_name(application);
        if (applicationName != 0L && (length = C.strlen(applicationName)) > 0) {
            buffer = new byte[length];
            C.memmove(buffer, applicationName, (long)length);
            program.name = new String(Converter.mbcsToWcs(buffer));
        }
        if ((applicationCommand = OS.g_app_info_get_executable(application)) != 0L && (length = C.strlen(applicationCommand)) > 0) {
            buffer = new byte[length];
            C.memmove(buffer, applicationCommand, (long)length);
            program.command = new String(Converter.mbcsToWcs(buffer));
        }
        program.gioExpectUri = OS.g_app_info_supports_uris(application);
        long icon = OS.g_app_info_get_icon(application);
        if (icon != 0L) {
            long icon_name = OS.g_icon_to_string(icon);
            if (icon_name != 0L) {
                length = C.strlen(icon_name);
                if (length > 0) {
                    buffer = new byte[length];
                    C.memmove(buffer, icon_name, (long)length);
                    program.iconPath = new String(Converter.mbcsToWcs(buffer));
                }
                OS.g_free(icon_name);
            }
            OS.g_object_unref(icon);
        }
        return program.command != null ? program : null;
    }

    static Program[] getPrograms(Display display) {
        long applicationList;
        long list = applicationList = OS.g_app_info_get_all();
        LinkedHashSet<Program> programs = new LinkedHashSet<Program>();
        while (list != 0L) {
            Program program;
            long application = OS.g_list_data(list);
            if (application != 0L && (program = Program.gio_getProgram(display, application)) != null) {
                programs.add(program);
            }
            list = OS.g_list_next(list);
        }
        if (applicationList != 0L) {
            OS.g_list_free(applicationList);
        }
        return programs.toArray(new Program[programs.size()]);
    }

    static boolean isExecutable(String fileName) {
        byte[] fileNameBuffer = Converter.wcsToMbcs(fileName, true);
        if (OS.g_file_test(fileNameBuffer, 4)) {
            return false;
        }
        if (!OS.g_file_test(fileNameBuffer, 8)) {
            return false;
        }
        long file = OS.g_file_new_for_path(fileNameBuffer);
        boolean result = false;
        if (file != 0L) {
            byte[] buffer = Converter.wcsToMbcs("*", true);
            long fileInfo = OS.g_file_query_info(file, buffer, 0L, 0L, 0L);
            if (fileInfo != 0L) {
                byte[] exeType;
                long contentType = OS.g_file_info_get_content_type(fileInfo);
                if (contentType != 0L && !(result = OS.g_content_type_is_a(contentType, exeType = Converter.wcsToMbcs("application/x-executable", true)))) {
                    byte[] shellType = Converter.wcsToMbcs("application/x-shellscript", true);
                    result = OS.g_content_type_equals(contentType, shellType);
                }
                OS.g_object_unref(fileInfo);
            }
            OS.g_object_unref(file);
        }
        return result;
    }

    static boolean gio_launch(String fileName) {
        boolean result = false;
        byte[] fileNameBuffer = Converter.wcsToMbcs(fileName, true);
        long file = OS.g_file_new_for_commandline_arg(fileNameBuffer);
        if (file != 0L) {
            long uri = OS.g_file_get_uri(file);
            if (uri != 0L) {
                result = OS.g_app_info_launch_default_for_uri(uri, 0L, 0L);
                OS.g_free(uri);
            }
            OS.g_object_unref(file);
        }
        return result;
    }

    boolean gio_execute(String fileName) {
        byte[] nameBuffer;
        boolean result = false;
        byte[] commandBuffer = Converter.wcsToMbcs(this.command, true);
        long application = OS.g_app_info_create_from_commandline(commandBuffer, nameBuffer = Converter.wcsToMbcs(this.name, true), this.gioExpectUri ? 2L : 0L, 0L);
        if (application != 0L) {
            byte[] fileNameBuffer = Converter.wcsToMbcs(fileName, true);
            long file = 0L;
            if (fileName.length() > 0) {
                file = OS.g_app_info_supports_uris(application) ? OS.g_file_new_for_uri(fileNameBuffer) : OS.g_file_new_for_path(fileNameBuffer);
            }
            long list = 0L;
            if (file != 0L) {
                list = OS.g_list_append(0L, file);
            }
            result = OS.g_app_info_launch(application, list, 0L, 0L);
            if (list != 0L) {
                OS.g_list_free(list);
                OS.g_object_unref(file);
            }
            OS.g_object_unref(application);
        }
        return result;
    }

    public static String[] getExtensions() {
        Map<String, List<String>> mimeInfo = Program.gio_getMimeInfo();
        if (mimeInfo == null) {
            return new String[0];
        }
        ArrayList<String> extensions = new ArrayList<String>(mimeInfo.keySet());
        return extensions.toArray(new String[extensions.size()]);
    }

    public static boolean launch(String fileName) {
        return Program.launch(Display.getCurrent(), fileName, null);
    }

    public static boolean launch(String fileName, String workingDir) {
        return Program.launch(Display.getCurrent(), fileName, workingDir);
    }

    static boolean launch(Display display, String fileName, String workingDir) {
        String extension;
        Program program;
        if (fileName == null) {
            SWT.error(4);
        }
        if (workingDir != null && Program.isExecutable(fileName)) {
            try {
                Compatibility.exec(new String[]{fileName}, null, workingDir);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        if (Program.gio_launch(fileName)) {
            return true;
        }
        int index = fileName.lastIndexOf(46);
        if (index != -1 && (program = Program.findProgram(display, extension = fileName.substring(index))) != null && program.execute(fileName)) {
            return true;
        }
        String lowercaseName = fileName.toLowerCase();
        if (lowercaseName.startsWith(PREFIX_HTTP) || lowercaseName.startsWith(PREFIX_HTTPS)) {
            program = Program.findProgram(display, ".html");
            if (program == null) {
                program = Program.findProgram(display, ".htm");
            }
            if (program != null && program.execute(fileName)) {
                return true;
            }
        }
        try {
            Compatibility.exec(new String[]{fileName}, null, workingDir);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Program)) {
            return false;
        }
        Program program = (Program)other;
        return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command) && this.gioExpectUri == program.gioExpectUri;
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        return this.gio_execute(fileName);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

