-- C45631A.ADA

--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained 
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making 
--     this public release, the Government intends to confer upon all 
--     recipients unlimited rights  equal to those held by the Government.  
--     These rights include rights to use, duplicate, release or disclose the 
--     released technical data and computer software in whole or in part, in 
--     any manner and for any purpose whatsoever, and to have or permit others 
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED 
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE 
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
-- CHECK THAT FOR TYPE INTEGER 'ABS A' EQUALS A IF A IS POSITIVE AND 
-- EQUALS -A IF A IS NEGATIVE.

-- RJW 2/10/86

WITH REPORT; USE REPORT;

PROCEDURE C45631A IS
     
BEGIN

     TEST ( "C45631A", "CHECK THAT FOR TYPE INTEGER 'ABS A' " &
                       "EQUALS A IF A IS POSITIVE AND EQUALS -A IF " & 
                       "A IS NEGATIVE" );

     DECLARE 
     
          P : INTEGER := IDENT_INT (1);
          N : INTEGER := IDENT_INT (-1);
          Z : INTEGER := IDENT_INT (0);
     BEGIN 

          IF ABS P = P THEN
               NULL;
          ELSE
               FAILED ( "'ABS' TEST FOR P - 1" );
          END IF;

          IF ABS N = -N THEN
               NULL;
          ELSE
               FAILED ( "'ABS' TEST FOR N - 1" );
          END IF;

          IF ABS Z = Z THEN
               NULL;
          ELSE
               FAILED ( "'ABS TEST FOR Z - 1" );
          END IF;

          IF ABS (Z) = -Z THEN
               NULL;
          ELSE
               FAILED ( "'ABS TEST FOR Z - 2");
          END IF;

          IF "ABS" (RIGHT => P) = P THEN
               NULL;
          ELSE
               FAILED ( "'ABS' TEST FOR P - 2" );
          END IF;

          IF "ABS" (N) = -N THEN
               NULL;
          ELSE
               FAILED ( "'ABS' TEST FOR N - 2 " );
          END IF;

          IF "ABS" (Z) = Z THEN
               NULL;
          ELSE
               FAILED ( "'ABS' TEST FOR Z - 3" );
          END IF;
         
          IF ABS (IDENT_INT (-INTEGER'LAST)) = INTEGER'LAST THEN
               NULL;
          ELSE
               FAILED ( "'ABS' TEST FOR -INTEGER'LAST" );
          END IF;
     END; 

     RESULT;

END C45631A;
