# Samoan

## Introduction

Formerly known as the *Navigator Islands*, the Samoan archipelago has been the launch site for countless ocean voyages since its settlement 3,000 years ago by the ancestors of today’s Polynesians. Like other Pacific Islander societies, the Samoans possessed an incredible body of astronomical knowledge, cultivated through generations of scientific observational study (tofāmamao). Over time, indigenous wayfinding science has been almost completely replaced by digital navigation technologies, but the names and stories attached to some celestial features have persisted through oral traditions and colonial era publications. Beside their value as nautical aids, the moon, stars, and planets also marked the lunar months, annual socioreligious festivals, and the timing of agricultural cycles.

## Description

### General Terminology

<dl>
  <dt><notr>fētū</notr></dt><dd>star</dd>
  <dt><notr>lā</notr></dt><dd>sun</dd>
  <dt><notr>māsina</notr></dt><dd>moon</dd>
  <dt><notr>lagi</notr></dt><dd>sky</dd>
  <dt><notr>fuifuifētū</notr></dt><dd>constellation ("star clusters")</dd>
  <dt><notr>ʻemoʻemo, ʻemaʻema</notr></dt><dd>twinkling</dd>
  <dt><notr>liʻo</notr></dt><dd>observed halo or reflective ring around star/moon</dd>
  <dt><notr>pupula</notr></dt><dd>light emitted by sun/star, reflected by moon</dd>
  <dt><notr>vānimonimo/vāteatea/vāuliuli</notr></dt><dd>outer space ("immeasurable space"/"expanse"/"dark void")</dd>
  <dt><notr>fētūafi/fētūlele/fētūatiafi</notr></dt><dd>meteor/shooting star ("fire star"/"flying star"/"fire-carrying star")</dd>
  <dt><notr>pusaloa</notr></dt><dd>comet ("smoke plume")</dd>
  <dt><notr>nuanua</notr></dt><dd>rainbow</dd>
  <dt><notr>sopolagi</notr></dt><dd>starpath/orbit</dd>
  <dt><notr>sila</notr></dt><dd>endpoint of starpath/orbit (point on the horizon where star/sun/moon/planet is seen to rise/set from)</dd>
  <dt><notr>maluopeaua</notr></dt><dd>the moment at which a star/moon/planet becomes visible at the horizon ("obscured in the sea mist")</dd>
  <dt><notr>goto/ifo/paʻū</notr></dt><dd>to set (descent of star/moon/sun/planet below the horizon)</dd>
  <dt><notr>oso/aʻe/fānaʻe/aufasa</notr></dt><dd>to rise (ascent of star/moon/sun /planet above the horizon)</dd>
  <dt><notr>fetāileliʻi</notr></dt><dd>navigational path formed by a series of constellations/stars rising in sequence</dd>
  <dt><notr>gasetoto</notr></dt><dd>solar eclipse</dd>
  <dt><notr>gaseʻeleʻele</notr></dt><dd>lunar eclipse</dd>
  <dt><notr>pulou</notr></dt><dd>zenith position</dd>
  <dt><notr>pale/faliu</notr></dt><dd>to descend from zenith position toward horizon</dd>
  <dt><notr>itūlagi</notr></dt><dd>spatial division of the sky/horizon</dd>
  <dt><notr>tafatafailagi</notr></dt><dd>horizon</dd>
  <dt><notr>tilotilo</notr></dt><dd>to catch a fleeting glance of star/moon during cloudy conditions</dd>
  <dt><notr>gālouluvao</notr></dt><dd>obstructed view of star/moon</dd>
  <dt><notr>lagivalea</notr></dt><dd>view of sky obstructed by clouds</dd>
  <dt><notr>fanoloa</notr></dt><dd>period of time when star/moon/planet is not visible</dd>
  <dt><notr>lagi e mamā/lagilelei/lagimā</notr></dt><dd>clear view of sky</dd>
  <dt><notr>mataʻaga</notr></dt><dd>the act of watching the sky for stars/signs</dd>
  <dt><notr>vaʻaiiliu</notr></dt><dd>to lay down in the hull to observe the sky above</dd>
  <dt><notr>fotu</notr></dt><dd>appearance of star/moon/sun/planet</dd>
  <dt><notr>galo</notr></dt><dd>disappearance of star/moon/sun/planet</dd>
</dl>

### Planet Terminology

<dl>
  <dt><notr>Tupualēgase</notr></dt><dd>("Undying Mystery") Jupiter; associated with the ritual observance of the Amo o Ātua iā Tupualēgase (the Ātua chiefdomʻs annual celebration of the deity Tupualēgase, who is embodied by the planet Jupiter).</dd>
  <dt><notr>Tapuʻitea</notr></dt><dd>("Forbidden Radiance") Venus; associated with the cannibal demigoddess Tapuʻitea who self-exiled herself to outer space to spare her son Toʻivā from her insatiable appetite; Toʻivā (abbreviation of Toʻivaitotonuoleʻatoatufuga) is also seen in the night sky as an adze-shaped constellation (Sickle of Leo); Venus is known to pass through Leo once (sometimes twice) a year, acknowledging the relationship between mother and son.</dd>
  <dt><notr>Fētūao</notr></dt><dd>("Morning Star") Venus when seen before sunrise; associated with the legend of Tapuʻitea.</dd>
  <dt><notr>Matamemea</notr></dt><dd>("Reddish Face/Surface") Mars.</dd>
  <dt><notr>Tāʻelo</notr></dt><dd>("Brownish") Mercury.</dd>
  <dt><notr>Fētūʻāsoa</notr></dt><dd>("Garland Star") Saturn.</dd>
</dl>

### Star Terminology

<dl>
  <dt><notr>Luatagata</notr></dt><dd>("Two Men") Alpha and Beta Centauri collectively; associated with the legend of Sumu (Crux, Southern Cross).</dd>
  <dt><notr>Filo/Mea</notr></dt><dd>Alpha and Beta Centauri individually (no distinction between the two); associated with the legend of Sumu (Crux, Southern Cross).</dd>
  <dt><notr>Suga/Pae</notr></dt><dd>M4 and M80 within Scorpius (no distinction between the two); associated with the legend of Toloa (head of Scorpius).</dd>
  <dt><notr>Fētūsolonuʻu</notr></dt><dd>("Gliding Star") Sirius; considered zenith star for traveling between Sāmoa and Fiji.</dd>
  <dt><notr>Telegese</notr></dt><dd>("Slow-Moving") Sirius; considered zenith star for traveling between Sāmoa and Fiji.</dd>
  <dt><notr>Taʻulua</notr></dt><dd>("Two Salutations") refers to Sirius during the part of the year when it is visible both at sunrise and sunset (thus "greeted twice" on the same day).</dd>
  <dt><notr>Taʻuluatuāfanua</notr></dt><dd>("Taʻulua Eastward") Sirius seen at sunrise.</dd>
  <dt><notr>Taʻuluaalofi</notr></dt><dd>("Taʻulua Westward") Sirius seen at sunset.</dd>
  <dt><notr>Aolele</notr></dt><dd>("Flying Cloud") Small Magellanic Cloud.</dd>
  <dt><notr>Aotea</notr></dt><dd>("Pale Cloud") Large Magellanic Cloud.</dd>
  <dt><notr>ʻAniva</notr></dt><dd>("Expanse") Milky Way.</dd>
</dl>

## Constellations

##### <notr>Sumu</notr>

("Triggerfish") Crux/Southern Cross; associated with the legend of Filo and Mea (Alpha and Beta Centauri) fishing for the Sumu.

##### <notr>Faipā</notr>

("Fishhook Lure") the entire hook shaped constellation of Scorpius; associated with the legend of ʻAloʻalolelā and the magic fishhook (pā).

##### <notr>Toloa</notr>

("Wild Duck") asterism within Faipā, representing a flying duck (head of Scorpius); associated with the legend of Suga and Pae (M4 and M80) hunting the Toloa; the duckʻs head (Antares) is recorded as having been used to sail from Pukapuka to ʻUpolu when the star was "low in the sky to the westward".

##### <notr>Tūlālupe</notr>

("Pigeon Perch") asterism within Faipā (distal tail of Scorpius); associated with the chiefly sport of pigeon snaring.

##### <notr>Matāliʻi</notr>

("Face of Liʻi") Pleiades (grouping of seven stars representing eyes, ears, nostrils, and mouth of demigod Liʻi); associated with the legend of a Tanifā (Cetus) pursuing a canoe paddled by Liʻi; acronychal rising of Matāliʻi signaled the beginning of the new year (Vāipālolo season) and ushered in the festivities of the first fruits (Talomua) during the lunar months of Taumafamua and Toetaumafa. Note: for display clarity and ease of use Matāliʻi is assigned to the star Alcyone.

##### <notr>Tanifā</notr>

("Sea Monster") Cetus (tail of Cetus is the head of Tanifā), pursuing Liʻi (Pleiades).

##### <notr>Iʻofi</notr>

("Tongs") Taurus; associated with the legend of Tiʻitiʻiatalaga/Maui.

##### <notr>Amoga</notr>

("Carrying Pole") constellation stretching from Pi-3 Orionis to Gamma Monocerotis; associated with the legend of Tiʻitiʻiatalaga; zenith star for traveling between Sāmoa and Tonga.

##### <notr>Tolugāmāuli</notr>

("Triad of Moons") asterism within Amoga (three stars of Orionʻs Belt); associated with legend of Tiʻitiʻiatalaga; noted as the "star course" to sail from Manuʻa to Pukapuka.

##### <notr>ʻAnava</notr>

("Warclub") constellation found largely within Ursa Major.

##### <notr>Tiʻotala</notr>

("Kingfisher") Delphinus; associated with the legend of the tiʻotala (kingfisher) ambushing the grasshopper (sē).

##### <notr>Sē</notr>

("Grasshopper") constellation found within Pegasus; associated with the legend of the tiʻotala (kingfisher) ambushing the grasshopper (sē).

##### <notr>Tuigālama</notr>

("Candlenut Torch") Orionʻs arm/club; associated with the legend of Tiʻitiʻiatalaga.

##### <notr>Toʻivā</notr>

("Great Adze") Sickle of Leo; associated with the legend of Tapuʻitea (Venus) and her son Toʻivāitotonuoleʻatoatufuga ("Great Adze Within the Builderʻs Tool Basket").

## References

 - [#1]: Brown, George (1910). Melanesians and Polynesians: Their Life Histories Described and Compared. MacMillan and Co.
 - [#2]: Collocott, E.E.V. (1922). Tongan Astronomy and Calendar. Occasional Papers of the Bernice Pauahi Bishop Museum, 8(4).
 - [#3]: Efi, Tui Ātua Tupua Tamasese (2009). Tupualegase: The Eternal Riddle. in Su’esu’e Manogi: In Search of Fragrance. National University of Samoa.
 - [#4]: Efi, Tui Ātua Tupua Tamasese, personal communications
 - [#5]: Johnson, Rubelite and Mahealona, John (1975). Nā Inoa Hōkū. Topgallant Publishing. Kirch, Patrick and Green, Roger (2001). Hawaiki, Ancestral Polynesia. Cambridge University Press.
 - [#6]: Kramer, Augustin (1994). The Samoa Islands, Volume 1. University of Hawaiʻi Press.
 - [#7]: Kramer, Augustin (1995). The Samoa Islands, Volume 2. Polynesian Press.
 - [#8]: Lefale, Penehuro (2010). Ua Afa le Aso. Climate Change, 100:317-335.
 - [#9]: Leuluaʻialiʻi, Lepanona, personal communications
 - [#10]: Lewis, David (1994). We the Navigators. University of Hawaiʻi Press.
 - [#11]: Makemson, Maud (1941). The Morning Star Rises. Yale University Press.
 - [#12]: Meleiseā, Leasiolagi Dr. Mālama, personal communications
 - [#13]: Noyes, Martha (2011). Polynesian Star Catalog, Revised. Self-published.
 - [#14]: Pratt, George (1893). A Grammar and Dictionary of the Samoan Language, 3rd Edition. London Missionary Society.
 - [#15]: Refiti, Lealiʻifano Dr. Albert, personal communications
 - [#16]: Seiulialiʻi, Seiuliali’i Pasikale, personal communications
 - [#17]: Simanu, Aumua (2002). O Si Manu a Aliʻi. University of Hawaiʻi Press.
 - [#18]: Smith, S. Percy (1892). Futuna, or Horne Island and Its People. In The Journal of the Polynesian Society, 1(1):33-52.
 - [#19]: Stair, John B. (1898). The Names and Movements of the Heavenly Bodies, as Looked at from a Samoan Point of View. The Journal of the Polynesian Society, 7(1):48-49.
 - [#20]: Stair, John B. (1897). Old Samoa or Flotsam and Jetsam from the Pacific Ocean. Religious Tract Society.
 - [#21]: Turner, George (1884). Samoa a Hundred Years Ago and Long Before. MacMillan and Co.
 - [#22]: Tuvale, Teʻo (1918). An Account of Samoan History up to 1918. M.L. MSS. 39 Item C. Manuscript filmed by Public Library of New South Wales, July 1968.

## Authors

This sky culture was contributed by Jake Fitisemanu (jjfitisemanu (a^t^) gmail.com) with consultation of Samoan cultural custodians and published historical sources. Programming support from Dan Smale.

## License

CC BY-SA 4.0
