# Maori

## Introduction

The Maori (New Zealand) night sky is similar to the Polynesian night sky. But it differs enough to warrant its own sky culture. Maritime themes are central to the Maori sky culture and were used extensively in nautical navigation. Along with most other cultures, the rising and setting of prominent stars were used to signal planting and harvesting seasons.

## Description

### Taatai-arorangi-maori

There are tribal ('iwi') variations in the naming of the stars and constellations. The names referenced below are the more well known names.

   |Object|Name|
   |--------|------|
   |Mercury|Takero|
   |Venus (morning star)|Tawera|
   |Venus (evening star)|Meremere|
   |Mars|Rangiwhenua|
   |Jupiter|Perearau|
   |Saturn|Perearau (Both Jupiter and Saturn have the same name)|
   |Altair|Poutu-te-Rangi|
   |Antares|Rehua|
   |S_Sco|Pekehawani|
   |T_Sco|Whakaonge-kai|
   |Canopus|Autahi|
   |Procyon|Puanga Hori|
   |Rigel|Puanga|
   |Sirius|Takarua|
   |Vega|Whanui|
   |Spica|Whiti-Kapeka or Mariao|
   |Arcturus|Ruawahia|
   |Castor|Whakaahu|
   |Pollux|Whakaahu (Both Castor and Pollux have the same name)|
   |Aldebaran|Taumatakuku|
   |Achernar|Turu|
   |Orion (whole belt)|Hao - o- rua|
   |Orion (the belt)|Tau toro|
   |Orion (a part)|Te Kakau|
   |Scorpio|Ruhi|
   |Scorpio (the tail)|Te Waka-o-Tama-Rereti|
   |Pleiades|Matariki|
   |Stars in the Pleiades (unspecified):|Tupua-nuku, Tupua-rangi, Ururangi, Wai-puna-a-rangi, Waiti, Waita|
   |Pointers|Te Taura Ra o Tainui|
   |Hyades|Te Kokota|
   |Southern Cross|Mahutonga|
   |Coal sack|Te Patiki|
   |Milky Way|Te ika o te rangi|
   |Large Magellanic cloud|Te Waka Ruru|
   |Small Magellanic cloud|Tuputuputu|
   |Double stars|Pipiri|
   |Comets|Auihi Turoa|
   |Ecliptic|Pito - o - Watea|
   |Moon|Te Marama|
   |Sun|Te Ra|
   |Te-Ra-o-Tainui|A maori constellation without a European counterpart. It is a sea voyaging catamaran. The belt of orion is the keel, the hyades is a claw sail and the Pleiades is the bow.|


## References

 - [#1]: [The Phoenix Astronomical Society](http://www.astronomynz.org/): a very good website on Maori sky culture (Wairarapa, New Zealand).
 - [#2]: Best, E. (1955) 'The astronomical knowledge of the Maori',Dominion Museum Monograph no.3 Wellington: Government Printer.
 - [#3]: Best, E. (1959) 'The Maori division of time',Dominion Museum Monograph no4. Wellington: Government Printer.
 - [#4]: Evans, J. (1998) 'The discovery of Aotearoa', Reed.
 - [#5]: Kingsley-Smith, C. (1967) 'Astronomers in puipuis. Maori Star lore', Southern Stars 22,5-10.
 - [#6]: Leather, K. and Hall, Richard (2004) 'Tatai Arorangi: Maori Astronomy, Work of the gods',Viking sevenseas nz ltd, Paraparaumu, NZ, ISBN:085467105 6.
 - [#7]: Lewis, D. (1994) 'We, the navigators. The ancient art of landfinding in the Pacific', University of Hawaii press.
 - [#8]: Orbell, M. (1996) 'The natural world of the Maori',David Bateman ltd.
 - [#9]: Orchiston, W. (1996) 'Australian Aboriginal, Polynesian and Maori Astronomy', Chapter in: 'Astronomy before the telescope' 318-328. Editor Chris Walker. BCA.

## Authors

This sky culture was contributed by Stellarium user *Dan Smale*, smaledaniel(at)outlook.com

## License

CC BY-SA 4.0
