/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.OuterLanguageElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlighterColors;
import org.intellij.plugins.markdown.highlighting.MarkdownSyntaxHighlighter;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0013\u001a\u00020\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/highlighting/MarkdownHighlightingAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "syntaxHighlighter", "Lorg/intellij/plugins/markdown/highlighting/MarkdownSyntaxHighlighter;", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateBasedOnParent", "predicate", "Lkotlin/Function1;", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "annotateWithHighlighter", "traverseAndCreateAnnotationsForContent", "textAttributesKey", "mergeRanges", "", "Lcom/intellij/openapi/util/TextRange;", "contentRanges", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownHighlightingAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownHighlightingAnnotator.kt\norg/intellij/plugins/markdown/highlighting/MarkdownHighlightingAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1#2:136\n1869#3,2:137\n1056#3:139\n*S KotlinDebug\n*F\n+ 1 MarkdownHighlightingAnnotator.kt\norg/intellij/plugins/markdown/highlighting/MarkdownHighlightingAnnotator\n*L\n94#1:137,2\n113#1:139\n*E\n"})
public final class MarkdownHighlightingAnnotator
implements Annotator,
DumbAware {
    @NotNull
    private final MarkdownSyntaxHighlighter syntaxHighlighter = new MarkdownSyntaxHighlighter();

    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        IElementType iElementType = PsiUtilCore.getElementType((PsiElement)element2);
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMPH)) {
            this.annotateBasedOnParent(element2, holder, (Function1<? super IElementType, TextAttributesKey>)((Function1)MarkdownHighlightingAnnotator::annotate$lambda$0));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BACKTICK)) {
            this.annotateBasedOnParent(element2, holder, (Function1<? super IElementType, TextAttributesKey>)((Function1)MarkdownHighlightingAnnotator::annotate$lambda$1));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.DOLLAR)) {
            this.annotateBasedOnParent(element2, holder, (Function1<? super IElementType, TextAttributesKey>)((Function1)MarkdownHighlightingAnnotator::annotate$lambda$2));
        } else {
            this.annotateWithHighlighter(element2, holder);
        }
    }

    private final void annotateBasedOnParent(PsiElement element2, AnnotationHolder holder, Function1<? super IElementType, TextAttributesKey> predicate) {
        PsiElement psiElement;
        block5: {
            block4: {
                psiElement = element2.getParent();
                if (psiElement == null) break block4;
                PsiElement p0 = psiElement;
                boolean bl = false;
                IElementType iElementType = PsiUtilCore.getElementType((PsiElement)p0);
                psiElement = iElementType;
                if (iElementType != null) break block5;
            }
            return;
        }
        PsiElement parentType = psiElement;
        TextAttributesKey attributes = (TextAttributesKey)predicate.invoke((Object)parentType);
        if (attributes != null) {
            this.traverseAndCreateAnnotationsForContent(element2, holder, attributes);
        }
    }

    private final void annotateWithHighlighter(PsiElement element2, AnnotationHolder holder) {
        IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_CONTENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE_CONTENT");
        if (PsiUtilsKt.hasType(element2, iElementType)) {
            PsiElement psiElement = element2.getParent();
            MarkdownCodeFence markdownCodeFence = psiElement instanceof MarkdownCodeFence ? (MarkdownCodeFence)psiElement : null;
            if ((markdownCodeFence != null ? markdownCodeFence.getFenceLanguage() : null) != null) {
                return;
            }
        }
        Object[] objectArray = this.syntaxHighlighter.getTokenHighlights(PsiUtilCore.getElementType((PsiElement)element2));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getTokenHighlights(...)");
        Object[] highlights = objectArray;
        TextAttributesKey textAttributesKey = (TextAttributesKey)ArraysKt.firstOrNull((Object[])highlights);
        if (textAttributesKey == null) {
            return;
        }
        TextAttributesKey parentAttributesKey = textAttributesKey;
        if (!Intrinsics.areEqual((Object)parentAttributesKey, (Object)MarkdownHighlighterColors.TEXT)) {
            this.traverseAndCreateAnnotationsForContent(element2, holder, parentAttributesKey);
        }
    }

    private final void traverseAndCreateAnnotationsForContent(PsiElement $this$traverseAndCreateAnnotationsForContent, AnnotationHolder holder, TextAttributesKey textAttributesKey) {
        List contentRanges = new ArrayList();
        $this$traverseAndCreateAnnotationsForContent.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(contentRanges){
            final /* synthetic */ List<TextRange> $contentRanges;
            {
                this.$contentRanges = $contentRanges;
            }

            public void visitElement(PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                IElementType type = PsiTreeUtilKt.getElementType((PsiElement)element2);
                if (!(type instanceof OuterLanguageElementType) && element2.getFirstChild() == null) {
                    TextRange textRange = element2.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    this.$contentRanges.add(textRange);
                }
                super.visitElement(element2);
            }
        });
        Collection<TextRange> mergedRanges = this.mergeRanges(contentRanges);
        Iterable $this$forEach$iv = mergedRanges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRange contentRange = (TextRange)element$iv;
            boolean bl = false;
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(textAttributesKey).range(contentRange).create();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<TextRange> mergeRanges(Collection<? extends TextRange> contentRanges) {
        void $this$sortedBy$iv;
        if (contentRanges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Set mergedRanges = new LinkedHashSet();
        Iterable iterable = contentRanges;
        boolean $i$f$sortedBy = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
        TextRange currentRange = (TextRange)sortedRanges.get(0);
        int n = sortedRanges.size();
        for (int i = 1; i < n; ++i) {
            TextRange nextRange = (TextRange)sortedRanges.get(i);
            if (currentRange.getEndOffset() == nextRange.getStartOffset()) {
                currentRange = new TextRange(currentRange.getStartOffset(), Math.max(currentRange.getEndOffset(), nextRange.getEndOffset()));
                continue;
            }
            mergedRanges.add(currentRange);
            currentRange = nextRange;
        }
        mergedRanges.add(currentRange);
        return mergedRanges;
    }

    private static final TextAttributesKey annotate$lambda$0(IElementType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IElementType iElementType = it;
        return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH) ? MarkdownHighlighterColors.ITALIC_MARKER : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG) ? MarkdownHighlighterColors.BOLD_MARKER : null);
    }

    private static final TextAttributesKey annotate$lambda$1(IElementType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IElementType iElementType = it;
        return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE) ? MarkdownHighlighterColors.CODE_FENCE_MARKER : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN) ? MarkdownHighlighterColors.CODE_SPAN_MARKER : null);
    }

    private static final TextAttributesKey annotate$lambda$2(IElementType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IElementType iElementType = it;
        return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_MATH) ? MarkdownHighlighterColors.CODE_FENCE_MARKER : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_MATH) ? MarkdownHighlighterColors.CODE_SPAN_MARKER : null);
    }
}

