/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.criteria;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class KeyNameCriterion
implements Criterion {
    @Nonnull
    @NotEmpty
    private String keyName;

    public KeyNameCriterion(@Nonnull @NotEmpty String name) {
        this.keyName = this.validateKeyName(name);
    }

    @Nonnull
    @NotEmpty
    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(@Nonnull @NotEmpty String name) {
        this.keyName = this.validateKeyName(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KeyNameCriterion [keyName=");
        builder.append(this.keyName);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.keyName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof KeyNameCriterion) {
            KeyNameCriterion namecrit = (KeyNameCriterion)obj;
            return this.keyName.equals(namecrit.keyName);
        }
        return false;
    }

    @Nonnull
    @NotEmpty
    public String validateKeyName(@Nonnull @NotEmpty String name) {
        String trimmed = StringSupport.trimOrNull(name);
        return Constraint.isNotNull(trimmed, "Key name criterion value cannot be null or empty");
    }
}

