/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.DocValuesType;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.compositeindex.datacube.DateDimension;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeFieldConfiguration;

@ExperimentalApi
public class StarTreeField
implements ToXContent {
    private final String name;
    private final List<Dimension> dimensionsOrder;
    private final List<Metric> metrics;
    private final StarTreeFieldConfiguration starTreeConfig;
    private final List<String> dimensionNames;
    private final List<DocValuesType> dimensionDocValueTypes;
    private final List<String> metricNames;

    public StarTreeField(String name, List<Dimension> dimensions, List<Metric> metrics, StarTreeFieldConfiguration starTreeConfig) {
        this.name = name;
        this.dimensionsOrder = dimensions;
        this.metrics = metrics;
        this.starTreeConfig = starTreeConfig;
        this.dimensionNames = new ArrayList<String>();
        this.dimensionDocValueTypes = new ArrayList<DocValuesType>();
        for (Dimension dimension : dimensions) {
            for (String dimensionName : dimension.getSubDimensionNames()) {
                this.dimensionNames.add(dimensionName);
                this.dimensionDocValueTypes.add(dimension.getDocValuesType());
            }
        }
        this.metricNames = new ArrayList<String>();
        for (Metric metric : metrics) {
            for (MetricStat metricStat : metric.getMetrics()) {
                this.metricNames.add(metric.getField() + "_" + metricStat.name());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public List<Dimension> getDimensionsOrder() {
        return this.dimensionsOrder;
    }

    public List<String> getDimensionNames() {
        return this.dimensionNames;
    }

    public List<DocValuesType> getDimensionDocValueTypes() {
        return this.dimensionDocValueTypes;
    }

    public List<String> getMetricNames() {
        return this.metricNames;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public StarTreeFieldConfiguration getStarTreeConfig() {
        return this.starTreeConfig;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        DateDimension dateDim = null;
        if (this.dimensionsOrder != null && !this.dimensionsOrder.isEmpty()) {
            builder.startArray("ordered_dimensions");
            for (Dimension dimension : this.dimensionsOrder) {
                if (dimension instanceof DateDimension) {
                    dateDim = (DateDimension)dimension;
                    continue;
                }
                dimension.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (dateDim != null) {
            dateDim.toXContent(builder, params);
        }
        if (this.metrics != null && !this.metrics.isEmpty()) {
            builder.startArray("metrics");
            for (Metric metric : this.metrics) {
                metric.toXContent(builder, params);
            }
            builder.endArray();
        }
        this.starTreeConfig.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StarTreeField that = (StarTreeField)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.dimensionsOrder, that.dimensionsOrder) && Objects.equals(this.metrics, that.metrics) && Objects.equals(this.starTreeConfig, that.starTreeConfig);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dimensionsOrder, this.metrics, this.starTreeConfig);
    }
}

