﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2-instance-connect/EC2InstanceConnect_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EC2InstanceConnect {
namespace Model {
class SendSerialConsoleSSHPublicKeyResult {
 public:
  AWS_EC2INSTANCECONNECT_API SendSerialConsoleSSHPublicKeyResult() = default;
  AWS_EC2INSTANCECONNECT_API SendSerialConsoleSSHPublicKeyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_EC2INSTANCECONNECT_API SendSerialConsoleSSHPublicKeyResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  SendSerialConsoleSSHPublicKeyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Is true if the request succeeds and an error otherwise.</p>
   */
  inline bool GetSuccess() const { return m_success; }
  inline void SetSuccess(bool value) {
    m_successHasBeenSet = true;
    m_success = value;
  }
  inline SendSerialConsoleSSHPublicKeyResult& WithSuccess(bool value) {
    SetSuccess(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;

  bool m_success{false};
  bool m_successHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2InstanceConnect
}  // namespace Aws
